
<?php
    $form = $this->beginWidget('CActiveForm', array(
    'id' => 'refund-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
    $cs = Yii::app()->getClientScript();


$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id) {
    var url = '" . Yii::app()->createUrl('invoice/Getcustomer') . "';
    $('#'+field_id).autocomplete({
        minLength   : 1,
        source      : function (request, response) { autoCompleteSource(request, response,url) },
        focus       : function( event, ui ) { },
        select          : function( event, ui ) {
            event.preventDefault();
            $('#RefundRequest_customer_name').val(ui.item.label);
            $('#RefundRequest_customer_id').val(ui.item.value);
        }
    })
}", CClientScript::POS_HEAD);
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php $model->customer_name = ( !$model->isNewRecord ) ? $model->cus->customer_name : ''; ?>
                <?php echo $form->textField($model, 'customer_name',array('data-label'=>'Customer', 'onKeyup' => 'js:autoCompleteCustomer(this.id);')); ?>
                <?php echo $form->hiddenField($model, 'id');?>
                <?php echo $form->hiddenField($model, 'customer_id');?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'invoice_no',array('data-label'=>'Invoice no')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'bill_of_entry',array('data-label'=>'BOE')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'amount',array('data-label'=>'Amount')); ?>
            </li>
            <?php 
                $model->date_requested = ( $model->date_requested != "0000-00-00" && !$model->isNewRecord ) ? date('d/m/Y',  strtotime( $model->date_requested )) : '';
                $model->date_received = ( $model->date_received != "0000-00-00" && !$model->isNewRecord  ) ? date('d/m/Y',  strtotime( $model->date_received )) : '';
            ?>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'date_requested',array('data-label'=>'Requested', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'date_received',array('data-label'=>'Received', 'class' => 'datepicker')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
        <a href="index.php"></a>
        
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        <?php
                $url = Yii::app()->createUrl('refund/save');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    if(data.status=="success"){  
                                         t8.success("Saved!");
                                         $("#loader").hide();
                                         $(".x.close").click();
                                         reloadTable("#tbl_refund");
                                    } else { 
                                        $("#loader").hide();
                                         $.each(data, function(key, val) {
                                                $("#country-form #"+key+"_em_").text(val).show(); 
                                                t8.error(""+val+""); 
                                            }); 
                                    } 
                                }',
                                'beforeSend' => 'function(){
                                    $("#loader").show();
                                 
                                }',
                            
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'btn btn-theme'));
           
    ?>
    </div>
<?php $this->endWidget(); ?>




