<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("loadOrder", '
        $(document).ready(function() {

        var table_id ="#tbl_order_details";
        var table = $(table_id).DataTable({
             scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            columns: [
                {className: ""},
                {className: ""},
                {className: ""},      
                {className: ""},      
                {className: "" },
                {className: ""},
                {className: "text-right" },
                {className: ""},
            ],
            ajax: {
                url: "' . Yii::app()->createUrl('Purchasingorder/GetOrderList') . '",
                type: "POST",
                cache : false,
            },
            aaSorting : [[ 0, "desc" ]], 
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
  ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="material-icons">list</i> Purchase Order
            <div class="pull-right">
                <?php if(isset(Yii::app()->user->havePermissionOn['purchase_order_add']) || Yii::app()->user->authorised_user == 1){?>
                <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('purchasingorder/create','Add New Order','xl')"><i class="fa fa-plus"></i> ADD</button>
                <?php }?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_order_details">
                    <thead>
                        <tr>
                           <th>Order ID</th>
                            <th>File</th>
                            <th>Title</th>
                            <th>Vendor</th>
                            <th>Order Date</th>
                            <th>Required Date</th>
                            <th>Total Value</th>
<!--                            <th>Status</th>-->
                            <th>Actions</th> 
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            
                            <th>Order ID</th>
                            <th>File</th>
                            <th>Title</th>
                            <th>Vendor</th>
                            <th>Order Date</th>
                            <th>Required Date</th>
                            <th>Total Value</th>
<!--                            <th>Status</th>-->
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
