<?php $cs = Yii::app()->getClientScript();?>
<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'accounts-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<ul class="clearfix form-ul material">   
    <li class="col-sm-4">      
        <?php echo $form->hiddenField($model, 'id'); ?>
        <?php 
        if($model->id == ''){
            $max = Yii::app()->db->createCommand('SELECT MAX(account_no) FROM crm_fin_accounts')->queryScalar();
            $model->account_no = $max+1;
        }
        ?>
        <?php echo $form->textField($model, 'account_no', array('class' => 'tooltipster', 'title' => 'Account Number','data-label' => 'Account No')); ?>
    </li>
    <li class="col-sm-4">               
        <?php echo $form->textField($model, 'description', array('class' => 'tooltipster', 'title' => 'Description','data-label' => 'Description')); ?>
       
    </li>
    <li class="col-sm-4">    
        <?php
            echo CHtml::activedropDownList($model, "parent_account", FinAccounts::getAllAccounts(), array('data-label' => 'Parent Account','data-search' =>true,'prompt' => '--select--',
                        'ajax' => array(
                        'type' => 'POST',
                        'dataType' => 'json',
                        'url' => CController::createUrl('finance/fetchparentfeatures'),
                        'success' => 'function(data){
                                if(data.status=="success"){
                                     
                                       $("#FinAccounts_credit_type").val(data.credit_type).addClass("filled");
                                       $("#FinAccounts_account_type").val(data.account_type).addClass("filled");
                                       $("#FinAccounts_routes").val(data.routes).addClass("filled");
                                }
                        }',
                        'data' => array('parent_account' => 'js:this.value'),
                    )));
                    ?>
    </li>
   <li class="col-sm-4">   
        <?php echo $form->dropDownList($model, 'cash_bank_type', array('BA' => 'Bank', 'CA' => 'Cash'), array('prompt'=>'--select--','class' => 'tooltipster', 'data-label' => 'Cash Bank Type')); ?>
   </li> 
   <li class="col-sm-4">     
        <?php echo $form->hiddenField($model, 'account_type'); ?>
        <?php echo $form->textField($model, 'opening_bal', array('class' => 'tooltipster', 'data-label' => 'Opening Balance')); ?>
        <?php echo $form->hiddenField($model, 'credit_type'); ?>
        <?php echo $form->hiddenField($model, 'routes'); ?>
   </li>
   <li class="col-sm-4">   
       <?php echo $form->dropDownList($model, 'opening_bal_type', array(1 => 'Credit', 2 => 'Debit'), array('prompt'=>'--select--','class' => 'tooltipster', 'data-label' => 'Opening Balance Type')); ?>
       
   </li> 
   <li class="col-sm-4">   
       <?php echo $form->dropDownList($model, 'isParent', array("Y" => 'YES', "N" => 'NO'), array('prompt'=>'--select--','class' => 'tooltipster', 'data-label' => 'Is Parent')); ?>
      
   </li>
    <li class="col-sm-4">   
        <?php echo $form->dropDownList($model, 'has_subledger', array("Y" => 'YES', "N" => 'NO'), array('prompt'=>'--select--','class' => 'tooltipster', 'data-label' => 'Has Subledger')); ?>
       
   </li>
</ul>
            <div class="modal-footer">               
                
             <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                <?php
                $url = Yii::app()->createUrl('finance/saveaccounts');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                 if(data.status == "success"){
                                    $("#loader").hide();
                                    t8.success("Account details saved");
                                    $(".x.close").click();
                                    reloadTable("#table_fin_acc");
                                 }else{             
                                   $("#loader").hide();
                                   $.each(data, function(key, val) {
                                       $("#accounts-form #"+key+"_em_").text(val).show();  
                                       t8.error(""+val+"","error");
                                   });                         
                                }
                            }',
                            'beforeSend' => 'function(){ 
                                    $("#loader").show();
                            }',
                            
                                ), array('id' => 'mybtn' . rand(), 'class' => 'accounts-add-btn btn btn-primary'));
                ?>
               
            </div>
<?php $this->endWidget(); ?>
       
<?php
$cs->registerScript("changedropdownofaccounts", "function changedropdownofaccounts(){
   
           jQuery.ajax({
             'type': 'post',
                    'dataType': 'json',
                    'url': '" . Yii::app()->createUrl('master/getParentaccounts') . "',
                     'success': function(data) { 
                     $('#FinAccounts_parent_account').html(data.parentaccount);
                     }
                    
                    });
                    
            }
            ", CClientScript::POS_HEAD);
?>