<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteFiles",  "function deleteFiles(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=File/delete',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    alert('Error while Delete', 'Alert');
                }else {
                    reloadTable('#tbl_file_details');
                    t8.success('File Deleted SuccessFully!','Success');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("load", '
        $(document).ready(function() {

        var table_id ="#tbl_file_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('file/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-link"></i> File    
            <div class="pull-right">
                <?php  if (isset(Yii::app()->user->havePermissionOn['mas_file_add']) ||  Yii::app()->user->authorised_user == 1) {?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('File/create','Add New File','lg')"><i class="fa fa-plus"></i> ADD</button>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_file_details">
                    <thead>
                        <tr>
                            <th>SI No</th>
                            <th>Title</th>
                            <th>File Name</th>
                            <th>Remarks</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                           <th>SI No</th>
                            <th>File</th>
                            <th>Title</th>
                            <th>Remarks</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
