<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("load", '$(document).ready(function() {

        var table_id ="#tbl_deposit";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('deposit/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-retweet"></i> Deposit    
            <div class="pull-right">
                <input type="text" id="deposit_from_date" name="deposit_from_date" class="datepicker" placeholder="From Date" value="<?php echo date('d/m/Y');?>">
                <input type="text" id="deposit_to_date" name="deposit_to_date" class="datepicker" placeholder="To Date" value="<?php echo date('d/m/Y');?>">
                <button class="btn btn-sm btn-theme" onclick="exportDeposit();"> Export to Excel</button>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('deposit/create','Add New Deposit','lg')"><i class="fa fa-plus"></i> ADD</button>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_deposit">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Customer</th>
                            <th>Invoice No</th>
                            <th>BOE</th>
                            <th>Amount</th>
                            <th>Issued</th>
                            <th>Expiry</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Customer</th>
                            <th>Invoice No</th>
                            <th>BOE</th>
                            <th>Amount</th>
                            <th>Issued</th>
                            <th>Expiry</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("exportDeposit", "function exportDeposit()
{
  var from_date     = $('#deposit_from_date').val();
  var to_date       = $('#deposit_to_date').val();
  var param         = '&from_date='+from_date+'&to_date='+to_date;
  //alert(param);
  var url           = $('#liveSite').val()+'index.php?r=excel/exportdepositlist'+param;
  window.open(url, '_blank');
}", CClientScript::POS_HEAD);
?>