
<?php
    $form = $this->beginWidget('CActiveForm', array(
    'id' => 'deposit-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
    $cs = Yii::app()->getClientScript();


$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id) {
    var url = '" . Yii::app()->createUrl('invoice/Getcustomer') . "';
    $('#'+field_id).autocomplete({
        minLength   : 1,
        source      : function (request, response) { autoCompleteSource(request, response,url) },
        focus       : function( event, ui ) { },
        select          : function( event, ui ) {
            event.preventDefault();
            $('#Deposit_customer_name').val(ui.item.label);
            $('#Deposit_customer_id').val(ui.item.value);
        }
    })
}", CClientScript::POS_HEAD);
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php $model->customer_name = ( !$model->isNewRecord ) ? $model->cus->customer_name : ''; ?>
                <?php echo $form->textField($model, 'customer_name',array('data-label'=>'Customer', 'onKeyup' => 'js:autoCompleteCustomer(this.id);')); ?>
                <?php echo $form->hiddenField($model, 'id');?>
                <?php echo $form->hiddenField($model, 'customer_id');?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'invoice_no',array('data-label'=>'Invoice no')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'bill_of_entry',array('data-label'=>'BOE')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'amount',array('data-label'=>'Amount')); ?>
            </li>
            <?php 
                $model->issued_date = ( $model->issued_date != "0000-00-00" && !$model->isNewRecord ) ? date('d/m/Y',  strtotime( $model->issued_date )) : '';
                $model->expiry_date = ( $model->expiry_date != "0000-00-00" && !$model->isNewRecord  ) ? date('d/m/Y',  strtotime( $model->expiry_date )) : '';
                $model->doc_submitted_date = ( $model->doc_submitted_date != "0000-00-00" && !$model->isNewRecord  ) ? date('d/m/Y',  strtotime( $model->doc_submitted_date )) : '';
                $model->customs_submitted_date = ( $model->customs_submitted_date != "0000-00-00" && !$model->isNewRecord  ) ? date('d/m/Y',  strtotime( $model->customs_submitted_date )) : '';
                $model->payment_collection_date = ( $model->payment_collection_date != "0000-00-00" && !$model->isNewRecord  ) ? date('d/m/Y',  strtotime( $model->payment_collection_date )) : '';
                $model->payment_delivery_date = ( $model->payment_delivery_date != "0000-00-00" && !$model->isNewRecord  ) ? date('d/m/Y',  strtotime( $model->payment_delivery_date )) : '';
            ?>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'issued_date',array('data-label'=>'Issued', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'expiry_date',array('data-label'=>'Expiry', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'statement_no',array('data-label'=>'Statement No')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'doc_submitted_date',array('data-label'=>'Doc Submitted', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'customs_submitted_date',array('data-label'=>'Customs Submitted', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'receipt_no',array('data-label'=>'Receipt No')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'payment_collection_date',array('data-label'=>'Payement Collected', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'collected_cheque_no',array('data-label'=>'Bank/Cheque')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'payment_delivery_date',array('data-label'=>'Delivered on', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'delivered_cheque_no',array('data-label'=>'Bank/Cheque')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
        <a href="index.php"></a>
        
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        <?php
                $url = Yii::app()->createUrl('deposit/save');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    if(data.status=="success"){  
                                         t8.success("Saved!");
                                         $("#loader").hide();
                                         $(".x.close").click();
                                         reloadTable("#tbl_deposit");
                                    } else { 
                                        $("#loader").hide();
                                         $.each(data, function(key, val) {
                                                $("#country-form #"+key+"_em_").text(val).show(); 
                                                t8.error(""+val+""); 
                                            }); 
                                    } 
                                }',
                                'beforeSend' => 'function(){
                                    $("#loader").show();
                                 
                                }',
                            
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'btn btn-theme'));
           
    ?>
    </div>
<?php $this->endWidget(); ?>




