<?php

/**
 * This is the model class for table "{{working_progress}}".
 *
 * The followings are the available columns in table '{{working_progress}}':
 * @property integer $id
 * @property integer $production_goods_issue_id
 * @property integer $product_id
 * @property integer $file_id
 * @property integer $count
 * @property string $goods_issue_date
 */
class WorkingProgress extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{working_progress}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('production_goods_issue_id, product_id, file_id, count, goods_issue_date', 'required'),
			array('production_goods_issue_id, product_id, file_id, count', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, production_goods_issue_id, product_id, file_id, count, goods_issue_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'production_goods_issue_id' => 'Production Goods Issue',
			'product_id' => 'Product',
			'file_id' => 'File',
			'count' => 'Count',
			'goods_issue_date' => 'Goods Issue Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('production_goods_issue_id',$this->production_goods_issue_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('file_id',$this->file_id);
		$criteria->compare('count',$this->count);
		$criteria->compare('goods_issue_date',$this->goods_issue_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return WorkingProgress the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
