<?php

/**
 * This is the model class for table "{{tendering_details_item}}".
 *
 * The followings are the available columns in table '{{tendering_details_item}}':
 * @property integer $id
 * @property integer $tendering_details_id
 * @property string $details
 * @property string $order_date
 * @property string $income
 * @property string $expence
 * @property string $created_date
 */
class TenderingDetailsItem extends CActiveRecord
{
       public $income_total;
       public $expence_total;
       public $net_profit_loss;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tendering_details_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_date,details', 'required'),
			array('tendering_details_id', 'numerical', 'integerOnly'=>true),
			array('details, income, expence', 'length', 'max'=>255),
                        array('order_date', 'date', 'format'=>'yyyy-mm-dd'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, tendering_details_id, details, order_date, income, expence, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'tenderdetails' => array(self::BELONGS_TO, 'TenderingDetails', 'tendering_details_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'tendering_details_id' => 'Tendering Details',
			'details' => 'Details',
			'order_date' => 'Order Date',
			'income' => 'Income',
			'expence' => 'Expence',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tendering_details_id',$this->tendering_details_id);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('order_date',$this->order_date,true);
		$criteria->compare('income',$this->income,true);
		$criteria->compare('expence',$this->expence,true);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TenderingDetailsItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
