<?php

/**
 * This is the model class for table "{{tendering_details}}".
 *
 * The followings are the available columns in table '{{tendering_details}}':
 * @property integer $id
 * @property integer $tender_id
 * @property integer $customer_vendor_id
 * @property string $address1
 * @property string $address2
 * @property string $phone
 * @property string $location
 * @property string $title
 * @property string $closing_date
 * @property string $description
 * @property string $income_total
 * @property string $expence_total
 * @property string $net_profit_loss
 * @property string $created_date
 */
class TenderingDetails extends CActiveRecord
{
         public $tender_no;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tendering_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tender_no,tender_id, customer_vendor_id', 'required'),
			array('tender_id, customer_vendor_id', 'numerical', 'integerOnly'=>true),
			array('phone, location, title, income_total, expence_total, net_profit_loss', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, tender_id, customer_vendor_id, address1, address2, phone, location, title, closing_date, description, income_total, expence_total, net_profit_loss, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'tender' => array(self::BELONGS_TO, 'TenderEnquireyDetals', 'tender_id'),
                    'company' => array(self::BELONGS_TO, 'Company', 'customer_vendor_id'),
                    'items' => array(self::HAS_MANY, 'TenderingDetailsItem', 'tendering_details_id', 'order' => 'items.id asc'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'tender_id' => 'Tender',
			'customer_vendor_id' => 'Customer Vendor',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'phone' => 'Phone',
			'location' => 'Location',
			'title' => 'Title',
			'closing_date' => 'Closing Date',
			'description' => 'Description',
			'income_total' => 'Income Total',
			'expence_total' => 'Expence Total',
			'net_profit_loss' => 'Net Profit Loss',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

            $criteria=new CDbCriteria;
                $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('tender_details_search')) : $searchterm;
                $criteria->with = array('tender', 'company');
                if (!empty($searchterm)) {
            $criteria->addCondition('   tender.tender_no like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%"  OR
                                        t.title like "%' . $searchterm . '%"
                                            ', 'AND');
        }	
            return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
            
		/*$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tender_id',$this->tender_id);
		$criteria->compare('customer_vendor_id',$this->customer_vendor_id);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('closing_date',$this->closing_date,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('income_total',$this->income_total,true);
		$criteria->compare('expence_total',$this->expence_total,true);
		$criteria->compare('net_profit_loss',$this->net_profit_loss,true);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));*/
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TenderingDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
