<?php

/**
 * This is the model class for table "crm_tender_enquirey_detals".
 *
 * The followings are the available columns in table 'crm_tender_enquirey_detals':
 * @property integer $id
 * @property integer $company_id
 * @property string $phone
 * @property string $address1
 * @property string $address2
 * @property integer $tender_no
 * @property string $description
 * @property integer $title
 * @property string $closing_date
 * @property string $link
 * @property string $document_name
 */
class TenderEnquireyDetals extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'crm_tender_enquirey_detals';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id,  tender_no', 'required'),
			array('company_id', 'numerical', 'integerOnly'=>true),
			array('phone', 'length', 'max'=>50),
                        array('current_status','safe'),
			array('address1, address2, link, document_name,tender_no, title,location', 'length', 'max'=>255),
                        array('description,closing_date,notes,remarks,terms_and_conditions', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, phone, address1, address2, tender_no, description, title, closing_date, link, document_name,created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'company' => array(self::BELONGS_TO, 'Company', 'company_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'phone' => 'Phone',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'tender_no' => 'Tender No',
			'description' => 'Description',
			'title' => 'Title',
			'closing_date' => 'Closing Date',
			'link' => 'Link',
                        'notes' => 'Notes',
                        'remarks' => 'Remarks',
                        'terms_and_conditions' => 'Terms And Conditions',
			'document_name' => 'Document Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search($searchterm = null)
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
                $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('enquiry_search')) : $searchterm;
                if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.tender_no like "%' . $searchterm . '%" OR
                                        t.location like "%' . $searchterm . '%" OR
                                        t.company_id like "%' . $searchterm . '%" 
                                            ', 'AND');
        }	
            return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TenderEnquireyDetals the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getTender() {
        $model = self::model()->findAll(array('order' => 'tender_no'));
        return CHtml::listData($model, 'id', 'tender_no');
    }
    public static function getTenders($status) {
        $model = self::model()->findAll(array('condition'=>'current_status="'.$status.'"','order' => 'tender_no'));
        return CHtml::listData($model, 'id', 'tender_no');
    }
    public function getStatus() {
        switch ($this->current_status) {
            case 'O':
                return 'Open';
                break;
            case 'BOQ':
                return 'BOQ';
                break;
            case 'S':
                return 'Submitted';
                break;
            case 'C':
                return 'Closed';
                break;
            case 'L':
                return 'lost';
                break;
        }
    }
    public function getTenderDetails() {
         return ($this->tender_no . ':' . $this->title);
    }

}
