<?php

class SystemController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Reset'),
                'expression' => '$user->isAdmin()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionReset() {
        $tables = array('activity', 'company_contact', 'company', 'company_type_relation', 'lead', 'quotes_item', 'quotes_deduction',
            'quotes_addition', 'quotes', 'order_item', 'order_deduction', 'order_addition', 'order', 'invoice_item', 'invoice', 'delivery_item',
            'delivery_note', 'creditnote_item', 'creditnote', 'rcpt_of_payment', 'master_file', 'document', 'purchasing_requisition_item',
            'purchasing_requisition', 'purchasing_enquiry_item', 'purchasing_enquiry', 'purchasing_order_item', 'purchasing_order_deduction',
            'purchasing_order_addition', 'purchasing_order', 'purchasing_material_receipt_item', 'purchasing_material_receipt', 'purchasinginvoice_item',
            'purchasing_invoice_addition', 'purchasing_invoice_deduction', 'purchasinginvoice', 'purchasingcredit_item', 'purchasingcredit',
            'allocated_materials', 'goods_return_item', 'goods_return', 'inventory_transfer', 'meeting', 'received_invoices');

        foreach ($tables as $table) {
            Yii::app()->db->createCommand('DELETE FROM {{' . $table . '}}')->execute();
        }
        Yii::app()->db->createCommand('UPDATE {{store}} SET rate=0, total_value=0')->execute();
        Yii::app()->db->createCommand('UPDATE {{product_location}} SET quantity=0')->execute();

        $tables_to_be_autoincremented = array(
            1000 => 'master_file', 1000 => 'company',
            100000 => 'lead', 100000 => 'quotes', 100000 => 'order',
            200000 => 'delivery_note',
            300000 => 'invoice',
            400000 => 'creditnote',
            500000 => 'purchasing_requisition', 500000 => 'purchasing_enquiry', 500000 => 'purchasing_order',
            600000 => 'purchasing_material_receipt',
            700000 => 'purchasinginvoice',
            800000 => 'purchasingcredit',
        );
        foreach ($tables_to_be_autoincremented as $autoinc => $table) {
            Yii::app()->db->createCommand('ALTER TABLE {{' . $table . '}} AUTO_INCREMENT = ' . $autoinc . ';')->execute();
        }
        echo 'success';
    }
}