<?php

/**
 * This is the model class for table "{{store}}".
 *
 * The followings are the available columns in table '{{store}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property string $part_number
 * @property string $generic_name
 * @property string $description
 * @property string $picture
 * @property string $product_class
 * @property double $rate
 * @property integer $unit_id
 * @property string $non_stock_item
 * @property string $isActive
 * @property integer $status
 * @property integer $tax_code
 * @property integer $mark_up
 * @property double $total_value
 * @property integer $country
 * @property integer $total_quantity
 *
 * The followings are the available model relations:
 * @property GoodsReturnItem[] $goodsReturnItems
 * @property InvoiceItem[] $invoiceItems
 * @property MasInvTax $taxCode
 * @property Unit $unit
 * @property MasCountry $country0
 * @property MasInvStatus $status0
 */
class Store extends CActiveRecord {

    public $tot_quantity_by_class;
    public $tot_value_by_class;
    public $sum_of_quantity;
    public $unit_name;
    public $tax_name;
    public $product_class;
    public $warehouse;
    public $from_bin;
    public $to_bin;
    public $from_rack;
    public $to_rack;
    public $from_part_no;
    public $to_part_no;
    public $sum;
    public $not_include_zero_qty;
    public $searchstartdate;
    public $searchenddate;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{store}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('crm_user_id, part_number,  description,  status, tax_code', 'required'),
            //array('company_id, company_branch_id, crm_user_id, unit_id, status, tax_code, mark_up, country, product_class_id', 'numerical', 'integerOnly' => true),
            array('crm_user_id,  status, tax_code, mark_up, country,', 'numerical', 'integerOnly' => true),
            array('total_value', 'numerical'),
            array('is_exit_default', 'length', 'max'=>1),
            array('rate, total_value, weight, volume', 'numerical'),
            array('from_part_no,to_part_no, part_number,  product_class, description, picture', 'length', 'max' => 255),
            array('picture', 'file',
                'types'=>'jpg, gif, png, bmp, jpeg',
                'maxSize'=>1024 * 1024 * 10, // 10MB
                'tooLarge'=>'The file was larger than 10MB. Please upload a smaller file.',
                'allowEmpty' => true
                ),
            array('part_number', 'unique', 'on' => 'add'),
            array('not_include_zero_qty,non_stock_item, isActive, is_default', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id, part_number,  description, product_class, rate,  
                non_stock_item, isActive, status, tax_code, mark_up, total_value, country', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'goodsReturnItems' => array(self::HAS_MANY, 'GoodsReturnItem', 'product_id'),
            'invoiceItems' => array(self::HAS_MANY, 'InvoiceItem', 'product_id'),
            'orderItems' => array(self::HAS_MANY, 'OrderItem', 'product_id'),
            'purchaseOrderItems' => array(self::HAS_MANY, 'PurchasingOrderItem', 'product_id'),
            'location' => array(self::HAS_MANY, 'ProductLocation', 'stock_id'),
            'taxCode' => array(self::BELONGS_TO, 'MasInvTax', 'tax_code'),        
            'country0' => array(self::BELONGS_TO, 'MasCountry', 'country'),
            'status0' => array(self::BELONGS_TO, 'MasInvStatus', 'status'),
            'inventory' => array(self::HAS_ONE, 'InventoryItems', 'stock_id'),            
            'price_list' => array(self::HAS_MANY, 'PriceGroupProductRelation', 'store_id'),
            'allocatedItems' => array(self::HAS_MANY, 'AllocatedMaterial', 'product_id'),
            'total_quantity' => array(self::STAT, 'ProductLocation', 'stock_id', 'select' => 'SUM(quantity)'),
            'total_sales_quantity' => array(self::STAT, 'DeliveryNoteItem', 'product_id', 'select' => 'SUM(picked_qty)'),
            'total_credit_quantity' => array(self::STAT, 'CreditnoteItem', 'product_id', 'select' => 'SUM(returned_quantity)'),
            'total_purchase_quantity' => array(self::STAT, 'PurchasingMaterialreceiptItem', 'product_id', 'select' => 'SUM(qcchecked_quantity)'),
            'total_debit_quantity' => array(self::STAT, 'PurchasingcreditItem', 'product_id', 'select' => 'SUM(returned_quantity)'),
            'total_inventory_issue_quantity' => array(self::STAT, 'InventoryGoodsIssueItem', 'product_id', 'select' => 'SUM(picked_qty)'),
            'total_inventory_receipt_quantity' => array(self::STAT, 'InventoryGoodsReceiptItem', 'product_id', 'select' => 'SUM(picked_qty)'),
            'total_production_issue_quantity' => array(self::STAT, 'ProductionGoodsIssueItem', 'product_id', 'select' => 'SUM(picked_qty)'),
            'total_production_receipt_quantity' => array(self::STAT, 'ProductionGoodsReceiptItem', 'product_id', 'select' => 'SUM(quantity)'),
            'inventory_uploaded_stock' => array(self::HAS_ONE, 'InventoryUploadedStock', 'product_id'),
            'po_quantity_all' => array(self::STAT, 'PurchasingOrderItem', 'product_id', 'select' => 'SUM(quantity)',
                'condition' => '(mf.current_process_status="P_O" || mf.current_process_status="P_MR" || mf.current_process_status="M_R")',
                'join' => '
                    JOIN {{purchasing_order}} as po  
                    JOIN {{master_file}} as mf 
                    
                    ON mf.id = po.file_id AND t.purchasing_order_id = po.id',
            ),
            'po_quantity_qc' => array(self::STAT, 'PurchasingMaterialreceiptItem', 'product_id', 'select' => 'SUM(qcchecked_quantity)',
                'condition' => '(mf.current_process_status="P_MR" || mf.current_process_status="M_R") AND mr.qcchecked="Y"',
                'join' => '                     
                    JOIN {{master_file}} as mf 
                    JOIN {{purchasing_material_receipt}} as mr
                    ON mr.file_id=mf.id AND t.purchasing_materialreceipt_id = mr.id',
            ),
            'po_quantity_all0' => array(self::STAT, 'PurchasingOrderItem', 'product_id', 'select' => 'SUM(quantity)',
                'condition' => '(mf.current_process_status="P_PI" OR mf.current_process_status="P_O" OR mf.current_process_status="P_MR" OR mf.current_process_status="M_R")',
                'join' => '
                    JOIN {{purchasing_order}} as po  
                    JOIN {{master_file}} as mf 
                    
                    ON mf.id = po.file_id AND t.purchasing_order_id = po.id',
            ),
            'po_quantity_qc0' => array(self::STAT, 'PurchasingMaterialreceiptItem', 'product_id', 'select' => 'SUM(qcchecked_quantity)',
                'condition' => '(mf.current_process_status="P_PI" OR mf.current_process_status="P_MR" OR mf.current_process_status="M_R") AND mr.qcchecked="Y"',
                'join' => '                     
                    JOIN {{master_file}} as mf 
                    JOIN {{purchasing_material_receipt}} as mr
                    ON mr.file_id=mf.id AND t.purchasing_materialreceipt_id = mr.id',
            ),
            'so_quantity' => array(self::STAT, 'OrderItem', 'product_id', 'select' => 'SUM(quantity)',
                'condition' => 'mf.current_process_status="O"',
                'join' => '
                    JOIN {{order}} as o  
                    JOIN {{master_file}} as mf 
                    ON mf.id = o.file_id AND t.order_id = o.id',
            ),
            'total_quantity_in_default_ware_house' => array(self::STAT, 'ProductLocation', 'stock_id', 'select' => 'SUM(quantity)',
                'condition' => 'wh.isBaseWareHouse="Y"',
                'join' => 'LEFT JOIN {{mas_inv_warehouse}} as wh ON t.warehouse_id = wh.id',
            ),
            'total_allocated_quantity' => array(self::STAT, 'AllocatedMaterial', 'product_id', 'select' => 'SUM(count)',
                'condition' => 'allocation_end_date >="' . date('Y-m-d') . '"'),
                // 'allocated_materiel' => array(self::HAS_MANY, 'AllocatedMaterial', 'product_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'part_number' => 'Part Number',            
            'description' => 'Description',            
            'rate' => 'Rate',            
            'non_stock_item' => 'Is this a Non Stockable Item(Service charges)?',
            'isActive' => 'Is Active',
            'status' => 'Status',
            'tax_code' => 'Tax Code',
            'mark_up' => 'Mark Up',
            'total_value' => 'Total Value',
            'country' => 'Country of Origin',
            'weight' => 'Weight/Unt.',
            'volume' => 'Volume/Unt.',
            'picture' => 'Picture'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    /* public function search() {
      // @todo Please modify the following code to remove attributes that should not be searched.

      $criteria = new CDbCriteria;

      $criteria->compare('id', $this->id);
      $criteria->compare('company_id', Yii::app()->user->master_user_company_id);
      $criteria->compare('company_branch_id', Yii::app()->user->master_user_branch_id);
      $criteria->compare('crm_user_id', $this->crm_user_id);
      $criteria->compare('part_number', $this->part_number, true);
      $criteria->compare('generic_name', $this->generic_name, true);
      $criteria->compare('description', $this->description, true);
      $criteria->compare('product_class', $this->product_class, true);
      $criteria->compare('rate', $this->rate);
      $criteria->compare('unit_id', $this->unit_id);
      $criteria->compare('non_stock_item', $this->non_stock_item, true);
      $criteria->compare('isActive', $this->isActive, true);
      $criteria->compare('status', $this->status);
      $criteria->compare('tax_code', $this->tax_code);
      $criteria->compare('mark_up', $this->mark_up);
      $criteria->compare('total_value', $this->total_value);
      $criteria->compare('country', $this->country);
      if (isset($_POST['product_class']))
      $criteria->condition = "product_class='" . $_POST['product_class'] . "'";
      if (isset($_POST['search']))
      $criteria->condition = " part_number like '%" . $_POST['search'] . "%' or generic_name like '%" . $_POST['search'] . "%' or description like '%" . $_POST['search'] . "%' or product_class like '%" . $_POST['search'] . "%' AND company_id=".Yii::app()->user->master_user_company_id.' AND company_branch_id ='.Yii::app()->user->master_user_branch_id;

      return new CActiveDataProvider($this, array(
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.part_number,t.generic_name,t.product_class',
      ),
      'pagination' => array('pageSize' => 5)
      ));
      } */
    public function getPo_quantity() {
        return ($this->po_quantity_all0 - $this->po_quantity_qc0);
    }

    public function nonstock() {
        $criteria = new CDbCriteria;

        $criteria->addCondition('non_stock_item="Y"', 'AND');

        /*$criteria->addCondition('       t.company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        t.company_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.part_number',
            ),
            'pagination' => false
        ));
    }

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('location', 'location.bin0', 'location.rack0','price_list');
        $criteria->together = true;
        /* if (!empty($this->non_stock_item))
          $criteria->addCondition('non_stock_item="' . $this->non_stock_item . '"', 'AND'); */
        if (!empty($this->not_include_zero_qty) && $this->not_include_zero_qty == "Y")
            $criteria->addCondition('location.quantity>0  OR non_stock_item="Y"', 'AND');
        /*if (!empty($this->product_class))
            $criteria->addCondition('t.product_class_id = ' . $this->product_class, 'AND');*/
        if (!empty($this->description))
            $criteria->addCondition('t.description like "%' . $this->description . '%"', 'AND');
        /*if (!empty($this->generic_name))
            $criteria->addCondition('t.generic_name like "%' . $this->generic_name . '%"', 'AND');*/
        if (!empty($this->warehouse))
            $criteria->addCondition('location.warehouse_id=' . $this->warehouse, 'AND');

        if (!empty($this->from_part_no) && !empty($this->to_part_no)) {
            $criteria->addBetweenCondition('t.part_number', $this->from_part_no, $this->to_part_no);
        } else if (!empty($this->from_part_no))
            $criteria->addCondition('t.part_number ="' . $this->from_part_no . '"', 'AND');
        else if (!empty($this->to_part_no))
            $criteria->addCondition('t.part_number ="' . $this->to_part_no . '"', 'AND');

        if (!empty($this->from_bin) && !empty($this->to_bin)) {
            $criteria->addBetweenCondition('bin0.name', $this->from_bin, $this->to_bin);
        }
        if (!empty($this->from_rack) && !empty($this->to_rack)) {
            $criteria->addBetweenCondition('rack0.name', $this->from_rack, $this->to_rack);
        }
       /* $criteria->addCondition('       t.company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        t.company_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        

return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.part_number',
            ),
            'pagination' => false
        ));
    }

    public function stockmovementreport() {
        $criteria = new CDbCriteria;
        $criteria->with = array('location', 'location.bin0', 'location.rack0');
        $criteria->together = true;
        /*if (!empty($this->product_class_id))
            $criteria->addCondition('t.product_class_id = ' . $this->product_class_id, 'AND');*/
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('enq_date', $this->searchstartdate, $this->searchenddate);
        }
       /* $criteria->addCondition('       t.company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        t.company_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.part_number',
            ),
           // 'pagination' => false
        ));
    }

    /* public function minreport() {
      $criteria = new CDbCriteria;
      $criteria->select= '*';
      $criteria->join= 'JOIN `crm_product_location` AS lc ON t.id = lc.stock_id
      JOIN `crm_inventory_items` AS i ON lc.stock_id = i.stock_id';
      $criteria->group='lc.stock_id';
      $criteria->having='SUM(lc.quantity)<i.re_order_level';
      return new CActiveDataProvider($this, array(
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.part_number,t.generic_name',
      ),
      'pagination' => false
      ));
      } */

    public function purchaseHistory($searchterm = null) {
        $criteria = new CDbCriteria;
        $criteria->with = array('purchaseOrderItems');
        $criteria->together = FALSE;


       /* $criteria->addCondition('t.company_id =' . Yii::app()->user->master_user_company_id .
                ' AND  t.company_branch_id =' . Yii::app()->user->master_user_branch_id, 'AND');*/

        $criteria->addCondition('purchaseOrderItems.quantity>0', 'AND');
        $searchterm = trim(Yii::app()->request->getParam('search'));
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.part_number like "%' . $searchterm . '%" OR                                         
                                        t.description like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.part_number,productclass.product_class*/',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false
        ));
    }

    public function salesHistory($searchterm = null) {
        $criteria = new CDbCriteria;
        $criteria->with = array('orderItems');
        $criteria->together = TRUE;

        //$criteria->addCondition('t.company_id =' . Yii::app()->user->master_user_company_id . ' AND  t.company_branch_id =' . Yii::app()->user->master_user_branch_id, 'AND');

        $criteria->addCondition('orderItems.quantity>0', 'AND');
        $searchterm = trim(Yii::app()->request->getParam('search'));
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.part_number like "%' . $searchterm . '%" OR                                         
                                        t.description like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.part_number,productclass.product_class*/',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false
        ));
    }

    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        $criteria->with = array('productclass', 'location' => array(
                'together' => true,
            ),);
        $criteria->group = 't.id';
        //$criteria->together = TRUE;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('search')) : $searchterm;
        $brandsearch = trim(Yii::app()->request->getParam('brand'));
        $quantitysearch = Yii::app()->request->getParam('quantity');
         $criteria->addCondition('t.isActive ="Y"','AND');
        //$criteria->addCondition('t.company_id =' . Yii::app()->user->master_user_company_id . ' AND  t.company_branch_id =' . Yii::app()->user->master_user_branch_id, 'AND');
        //$criteria->addCondition('AND  t.status =1','AND');
        //$criteria->addCondition('location.quantity>0 OR non_stock_item="Y"', 'AND');
        /*if (isset($_GET['product_class']))
            $criteria->addCondition('t.product_class_id=' . $_GET['product_class'], 'AND');*/
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.part_number like "%' . $searchterm . '%" OR                                         
                                        t.description like "%' . $searchterm . '%"', 'AND');
        }
        /*if (!empty($brandsearch)) {
            $criteria->addCondition('   t.product_class_id=' . $brandsearch, 'AND');
        }*/
        if ($quantitysearch) {
            $criteria->addCondition('location.quantity>0  OR non_stock_item="Y"', 'AND');
        }
        if (isset($_POST['exp_month'])) {
            $criteria->with = 'inventory';
            $criteria->addCondition("YEAR(inventory.expiry_date)='" . date('Y') . "' AND MONTH(inventory.expiry_date) ='" . date('m', strtotime($_POST['exp_month'])) . "'", 'AND');
        }

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.part_number,productclass.product_class*/',
            ),
            //  'pagination' => false
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Store the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getAll($only_non_zero_quantity = false, $only_stock_item = false, $list = true) {
        $criteria = new cdbCriteria;
        //$criteria->addCondition('isActive =  "Y" AND t.company_id=' . Yii::app()->user->master_user_company_id . ' AND t.company_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');

        if ($only_non_zero_quantity)
            $criteria->addCondition(" AND location.quantity > 0", 'AND');
        if ($only_stock_item)
            $criteria->addCondition(" AND non_stock_item ='N'", 'AND');
        $criteria->order = 'part_number';
        $criteria->with = 'location';
        $criteria->select = array('id', 'part_number');
        $model = self::model()->findAll($criteria);
        if ($list)
            return CHtml::listData($model, 'id', 'part_number');
        else
            return $model;
    }

    public function renderOrderedQuantity($data, $row) {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(quantity) FROM 
            {{order_item}} 
            where product_id=" . $data->id);
        if ($command->queryScalar() > 0)
            return Yii::app()->format->formatNumber($command->queryScalar());
        else
            return 0;
    }

    public function renderDeliveredQuantity($data, $row) {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(picked_qty) FROM 
            {{delivery_item}} 
            where product_id=" . $data->id);
        if ($command->queryScalar() > 0)
            return Yii::app()->format->formatNumber($command->queryScalar());
        else
            return 0;
    }

    public function renderInvoicedQuantity($data, $row) {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(quantity) FROM 
            {{invoice_item}} 
            where product_id=" . $data->id);
        if ($command->queryScalar() > 0)
            return Yii::app()->format->formatNumber($command->queryScalar());
        else
            return 0;
    }

    public function renderOrderedQuantityforPurchase($data, $row) {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(quantity) FROM 
            {{purchasing_order_item}} 
            where product_id=" . $data->id);
        if ($command->queryScalar() > 0)
            return Yii::app()->format->formatNumber($command->queryScalar());
        else
            return 0;
    }

    public function renderReceivedQuantityforPurchase($data, $row) {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(qcchecked_quantity) FROM 
            {{purchasing_material_receipt_item}} 
            where product_id=" . $data->id);
        if ($command->queryScalar() > 0)
            return Yii::app()->format->formatNumber($command->queryScalar());
        else
            return 0;
    }

    public function getLocations() {
        $productResidingLocations = ProductLocation::model()->findAll(array('condition' => 'stock_id=' . $this->id));
        $location = array();
        foreach ($productResidingLocations as $eachLocation) {
            $location[] = $eachLocation->warehouse->name;
        }
        return implode(',', $location);
    }

    public function getIsProductHasHistory() {
        $userLevel = User::model()->findByPK(Yii::app()->user->id)->level;
        if ($userLevel == 0)
            return 0;
        else if ((int) Yii::app()->user->havePermissionOn['permission_for_rate_edit'])
            return 0;
        return (((AllocatedMaterial::model()->count('product_id=' . $this->id) +
                InventoryGoodsIssueItem::model()->count('product_id=' . $this->id) +
                InventoryGoodsReceiptItem::model()->count('product_id=' . $this->id) +
                QuotesItem::model()->count('product_id=' . $this->id) +
                OrderItem::model()->count('product_id=' . $this->id) +
                DeliveryNoteItem::model()->count('product_id=' . $this->id) +
                InvoiceItem::model()->count('product_id=' . $this->id) +
                CreditnoteItem::model()->count('product_id=' . $this->id) +
                GoodsReturnItem::model()->count('product_id=' . $this->id) +
                ProductionBillofmaterialItem::model()->count('product_id=' . $this->id) +
                ProductionGoodsIssueItem::model()->count('product_id=' . $this->id) +
                ProductionGoodsReceiptItem::model()->count('product_id=' . $this->id) +
                ProductionOrderItem::model()->count('product_id=' . $this->id) +
                PurchasingcreditItem::model()->count('product_id=' . $this->id) +
                PurchasingInvoiceItem::model()->count('product_id=' . $this->id) +
                PurchasingEnquiryItem::model()->count('product_id=' . $this->id) +
                PurchasingOrderItem::model()->count('product_id=' . $this->id) +
                PurchasingMaterialreceiptItem::model()->count('product_id=' . $this->id) +
                PurchasingRequisitionItem::model()->count('product_id=' . $this->id)
                ) != 0 ) && ($this->rate > 0) );
    }

    public function getPoquantity($x) {
        return $x;
    }

    public static function getItems(){
        return CHtml::listdata(self::model()->findAll(array('condition'=>'isActive="Y" AND status=1')), 'id', 'part_number');
    }

}
