<?php

/**
 * This is the model class for table "{{shift}}".
 *
 * The followings are the available columns in table '{{shift}}':
 * @property integer $id
 * @property string $opening_time
 * @property string $opening_date
 * @property string $opening_balance
 * @property integer $user_id
 * @property string $closing_time
 * @property string $closing_date
 * @property string $closing_balance
 * @property string $cash_collected
 * @property string $cheque_collected
 * @property string $credit_amount
 * @property string $invoice_amount
 * @property string $status
 */
class Shift extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{shift}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('opening_time, opening_date, opening_balance, user_id', 'required'),
			array('user_id', 'numerical', 'integerOnly'=>true),
			array('opening_time, closing_time', 'length', 'max'=>25),
			array('opening_balance, closing_balance, cash_collected, cheque_collected, credit_amount, invoice_amount, amount_deposited, expenses, income', 'length', 'max'=>15),
			array('status', 'length', 'max'=>2),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, opening_time, opening_date, opening_balance, user_id, closing_time, closing_date, closing_balance, cash_collected, cheque_collected, credit_amount, invoice_amount, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'user' => array(self::BELONGS_TO, 'User','user_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'opening_time' => 'Opening Time',
			'opening_date' => 'Opening Date',
			'opening_balance' => 'Opening Balance',
			'user_id' => 'User',
			'closing_time' => 'Closing Time',
			'closing_date' => 'Closing Date',
			'closing_balance' => 'Closing Balance',
			'cash_collected' => 'Cash Collected',
			'cheque_collected' => 'Cheque Collected',
			'credit_amount' => 'Credit Amount',
			'invoice_amount' => 'Invoice Amount',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('opening_time',$this->opening_time,true);
		$criteria->compare('opening_date',$this->opening_date,true);
		$criteria->compare('opening_balance',$this->opening_balance,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('closing_time',$this->closing_time,true);
		$criteria->compare('closing_date',$this->closing_date,true);
		$criteria->compare('closing_balance',$this->closing_balance,true);
		$criteria->compare('cash_collected',$this->cash_collected,true);
		$criteria->compare('cheque_collected',$this->cheque_collected,true);
		$criteria->compare('credit_amount',$this->credit_amount,true);
		$criteria->compare('invoice_amount',$this->invoice_amount,true);
		$criteria->compare('status',$this->status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Shift the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
