<?php

class RmaSendVendor extends CActiveRecord {
    public $file;
    public function tableName() {
        return '{{rma_send_vendor}}';
    }

    public function rules() {
        return array(
            array('rma_file_id,rma_date,company_id,file_no,delivery_note_no,create_user_id,item_from', 'required'),
            array('rma_file_id,company_id,file_no,delivery_note_no,create_user_id,item_from', 'numerical', 'integerOnly' => true),
            array('notes', 'length', 'max'=>255),
            array('rma_file_id,company_id,file_no,delivery_note_no,create_user_id,notes', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
        'company' => array(self::BELONGS_TO, 'Company', 'company_id'),   
        );
    }
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'rma_date' => 'Date',
            'company_id' => 'Customer',
            'file_no' => 'File No',
            'delivery_note_no' => 'Deliverynote No',
        );
    }

    
    public function search() {
        $criteria = new CDbCriteria;
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
