<?php

class RmaMasterFile extends CActiveRecord {

    public function tableName() {
        return '{{rma_master_file}}';
    }

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('user_id, start_from, current_process_status,company_id', 'required'),
            array('user_id, start_from, current_process_status,company_id', 'numerical', 'integerOnly' => true),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('user_id, start_from, current_process_status,company_id,isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
           
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'user_id' => 'Crm User',
            'company_id' => 'Customer',
            'start_from' => 'Start From',
            'current_process_status' => 'Current Process Status',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.
        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('company_id', $this->company_id);
        $criteria->compare('start_from', $this->start_from, true);
        $criteria->compare('current_process_status', $this->current_process_status, true);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getFiles($current_process_status = null, $notNeedlist = false) {
        $condition = 'isActive="Y"';
        if ($current_process_status != null) {
            if (is_array($current_process_status))
                $current_process_status = implode('","', $current_process_status);
            $condition.=' AND current_process_status in ("' . $current_process_status . '")';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'id DESC,current_process_status'));
        if ($notNeedlist)
            return $model;
        else
            return CHtml::listData($model, 'id', 'id_with_status');
    }

  

    public function getId_with_status() {
        return $this->id . ':' . $this->status;
    }

    public function getStatus() {
        switch ($this->current_process_status) {
            case 1:
                return 'Receipt';
                break;
            case 2:
                return 'Send to vendor';
                break;
            case 3:
                return 'From Vendor';
                break;
            case 4:
                return 'Send to Customer';
                break;
        }
    }
}
