<?php

/**
 * This is the model class for table "{{purchasing_enquiry}}".
 *
 * The followings are the available columns in table '{{purchasing_enquiry}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $requisition_id
 * @property string $enquiry_date
 * reference
 * @property string $note
 * @property string $delivery_date
 */
class PurchasingEnquiry extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
   // public $title;
    public $vendors;
    public $tendor_no;

    public function tableName() {
        return '{{purchasing_enquiry}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('crm_user_id,vendor_id enquiry_date,isActive,title,required_date', 'required'),
            array('crm_user_id, tender_file_id', 'numerical', 'integerOnly' => true),
            array('vendor_id,title,reference,requisition_id', 'length', 'max' => 255),
            array('isActive,send_email', 'length', 'max' => 1),
            array('notes,note,terms_and_conditions,remarks', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id,vendor_id,tender_file_id,send_email, enquiry_date,closing_date,required_date, delivery_date,reference,isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'items' => array(self::HAS_MANY, 'PurchasingEnquiryStockItem', 'purchasing_enquiry_id','order' => 'items.id asc'),
            'nonstockitems' => array(self::HAS_MANY, 'PurchasingEnquiryNonStockItem', 'purchasing_enquiry_id','order' => 'nonstockitems.id asc'),
            //'enquiry' => array(self::BELONGS_TO, 'PurchasingRequisition', 'requisition_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'title' => 'Title',
            'note' => 'Internal Note',
            'enquiry_date' => 'Enquiry Date',
            'closing_date' => 'Closing Date',
            'delivery_date' => 'Delivery Date',
            'vendor_id' => 'Vendors',
            'reference' => 'Reference',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('enq_search')) : $searchterm;
        $criteria->with = array('file', 'file.company');
 
        //((int) Yii::app()->session['company_id'] > 0 && !isset($_GET['month'])) ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%" OR 
                                        t.title like "%' . $searchterm . '%"', 'AND');
        }
        

        if (isset($_GET['month']))
            $criteria->addCondition("YEAR(enquiry_date)='" . date('Y') . "' AND MONTH(enquiry_date) ='" . date('m', strtotime($_GET['month'])) . "'", 'AND');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.enquiry_date DESC,t.id DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    public function generatereport() {
        $criteria = new CDbCriteria;
        $criteria->condition = "isActive   =   'Y'";
        if (isset($_POST['rp_from_date']) && isset($_POST['rp_to_date']))
            $criteria->condition .= ' AND enquiry_date BETWEEN "' . $_POST['rp_from_date'] . '" AND "' . $_POST['rp_to_date'] . '"';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.file_id DESC,t.enquiry_date DESC',
            ),
            'pagination' => FALSE
        ));
    }

    public function renderVendors($data, $row) {
        $vendors = explode(',', $data->vendor_id);
        $criteria = new CDbCriteria;
        $criteria->addInCondition('id', $vendors);
        $vend = Company::model()->findAll($criteria);
        $vendorlist = CHtml::listData($vend, 'id', 'company_name');
        return CHtml::dropDownList('vendor', '', $vendorlist, array('prompt' => 'select', 'class' => 'selectedvendor'));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingEnquiry the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
