<?php

/**
 * This is the model class for table "{{profit_calc_item}}".
 *
 * The followings are the available columns in table '{{profit_calc_item}}':
 * @property integer $id
 * @property integer $profit_calc_id
 * @property integer $product_id
 * @property string $cost_rate
 */
class ProfitCalcItemInternal extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{profit_calc_item_internal}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('profit_calc_id, product_id, cost_rate', 'required'),
			array('profit_calc_id, product_id', 'numerical', 'integerOnly'=>true),
			array('cost_rate', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, profit_calc_id, product_id, cost_rate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'profitCalcInternal' => array(self::BELONGS_TO, 'ProfitCalcInternal', 'profit_calc_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'profit_calc_id' => 'Profit Calc',
			'product_id' => 'Product',
			'cost_rate' => 'Cost Rate',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('profit_calc_id',$this->profit_calc_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('cost_rate',$this->cost_rate,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProfitCalcItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
