<?php

/**
 * This is the model class for table "{{production_goods_issue}}".
 *
 * The followings are the available columns in table '{{production_goods_issue}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $production_order_id
 * @property integer $file_id
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property string $isActive
 * @property integer $product_id
 * @property string $description
 * @property integer $quantity
 * @property string $reference
 * @property integer $customer_id
 * @property integer $connected_file
 * @property integer $project
 */
class ProductionGoodsIssue extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $customer_name;
    public $product_name;
    public $unit_name;
    public $project_name_in_goodsissue;
    public $connected_file_in_goodsissue;

    public function tableName() {
        return '{{production_goods_issue}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('production_order_id,goods_issue_date,description', 'required'),
            array('crm_user_id, production_order_id, file_id, product_id, quantity, customer_id, connected_file, project', 'numerical', 'integerOnly' => true),
            array('isActive', 'length', 'max' => 1),
            array('description, reference', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id,goods_issue_date,amount,production_order_id, file_id, notes, terms_and_conditions, remarks, isActive, product_id, description, quantity, reference, customer_id, connected_file, project', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'project' => array(self::BELONGS_TO, 'MasProject', 'project'),
            'customer' => array(self::BELONGS_TO, 'Company', 'customer_id'),
            'items' => array(self::HAS_MANY, 'ProductionGoodsIssueItem', 'production_goods_issue_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'production_order_id' => 'Production Order',
            'file_id' => 'File',
            'notes' => 'Notes',
            'terms_and_conditions' => 'Terms And Conditions',
            'remarks' => 'Remarks',
            'isActive' => 'Is Active',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'reference' => 'Reference',
            'customer_id' => 'Customer',
            'connected_file' => 'Connected File',
            'project' => 'Project',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    /* public function search() {
      // @todo Please modify the following code to remove attributes that should not be searched.

      $criteria = new CDbCriteria;

      $criteria->compare('id', $this->id);
      $criteria->compare('crm_user_id', $this->crm_user_id);
      $criteria->compare('production_order_id', $this->production_order_id);
      $criteria->compare('file_id', $this->file_id);
      $criteria->compare('notes', $this->notes, true);
      $criteria->compare('terms_and_conditions', $this->terms_and_conditions, true);
      $criteria->compare('remarks', $this->remarks, true);
      $criteria->compare('isActive', $this->isActive, true);
      $criteria->compare('product_id', $this->product_id);
      $criteria->compare('description', $this->description, true);
      $criteria->compare('quantity', $this->quantity);
      $criteria->compare('reference', $this->reference, true);
      $criteria->compare('customer_id', $this->customer_id);
      $criteria->compare('connected_file', $this->connected_file);
      $criteria->compare('project', $this->project);

      return new CActiveDataProvider($this, array(
      'criteria' => $criteria,
      ));
      } */
    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('goodsissue_search')) : $searchterm;
        $criteria->with = array('file', 'file.company','product');
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        //((int) Yii::app()->session['company_id'] > 0 && !isset($_GET['month'])) ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        product.part_number like "%' . $searchterm . '%" OR 
                                        product.description like "%' . $searchterm . '%" OR
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        }
        if (empty($searchterm))
        $criteria->addCondition('file.current_process_status="G_I"', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.goods_issue_date DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ProductionGoodsIssue the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
