<?php

/**
 * This is the model class for table "{{product_location}}".
 *
 * The followings are the available columns in table '{{product_location}}':
 * @property integer $stock_id
 * @property integer $bin
 * @property integer $rack
 * @property integer $weight
 * @property integer $warehouse_id
 * @property integer $quantity
 *
 * The followings are the available model relations:
 * @property MasInvWarehouse $warehouse
 * @property Store $stock
 * @property MasInvBin $bin0
 * @property MasInvRack $rack0
 */
class ProductLocation extends CActiveRecord {

    public $total_value;
    public $sum_of_quantity;
    public $warehouse_name;
    public $rack_name;
    public $bin_name;
    public $sum;
    public $product_class;
    public $warehouse1;
    public $from_bin;
    public $to_bin;
    public $from_rack;
    public $to_rack;
    public $from_part_no;
    public $to_part_no;
    public $description;
    public $generic_name;
    public $not_include_zero_qty;
    public $old_warehouse_id ;
    public $isDefault;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{product_location}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('warehouse_id, quantity', 'required'),
            //array('warehouse_id','unique'),
            //array('stock_id,sum,bin, rack, company_branch_id, warehouse_id, quantity', 'numerical', 'integerOnly' => true),
            array('stock_id,sum,bin, rack, warehouse_id', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('stock_id,sum,bin, rack, warehouse_id, quantity', 'safe', 'on' => 'search'),
            array('warehouse_id', 'UniqueAttributesValidator',
                      'with'=>'stock_id,bin,rack','message' => 'Warehouse with Rack & bin already taken'),
        );
       
        
    
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'warehouse' => array(self::BELONGS_TO, 'MasInvWarehouse', 'warehouse_id'),
            'stock' => array(self::BELONGS_TO, 'Store', 'stock_id'),
            'bin0' => array(self::BELONGS_TO, 'MasInvBin', 'bin'),
            'rack0' => array(self::BELONGS_TO, 'MasInvRack', 'rack'),
            'inventory' => array(self::BELONGS_TO, 'InventoryItems', 'stock_id'),
            'orderItems' => array(self::HAS_MANY, 'OrderItem', 'product_id'),
            'PurchaseorderItems' => array(self::HAS_MANY, 'PurchasingOrderItem', 'product_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'stock_id' => 'Stock',
            'bin' => 'Bin',
            'rack' => 'Rack',
            'warehouse_id' => 'Warehouse',
            'quantity' => 'Quantity',
            'created_by' => 'created_by',
            'updated_by' => 'updated_by',
            'created_date_time' => 'created_date_time',
            'updated_date_time' => 'updated_date_time'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function minreport() {
        $criteria = new CDbCriteria;
        $criteria->with = array('stock', 'inventory');
        $criteria->group = 't.stock_id';
        $criteria->having = 'SUM(quantity)<inventory.re_order_level';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.warehouse_id,t.bin,t.rack',
            ),
            'pagination' => false
        ));
    }

    /* public function minreport() {
      $criteria = new CDbCriteria;
      $criteria->with = array('stock','inventory','orderItems','PurchaseorderItems','orderItems.order','PurchaseorderItems.purchaseorder','orderItems.order.file','PurchaseorderItems.purchaseorder.file');
      $criteria->group='t.stock_id';
      $criteria->condition='purchaseorder.file.current_process_status="P_O" AND order.file.current_process_status="O"';
      $criteria->having='SUM(t.quantity)-SUM(orderItems.quantity)+SUM(PurchaseorderItems.quantity)<inventory.re_order_level';
      return new CActiveDataProvider($this, array(
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.warehouse_id,t.bin,t.rack',
      ),
      'pagination' => false
      ));
      } */

    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('stock_id', Yii::app()->session['stock_id']);
        $criteria->compare('bin', $this->bin);
        $criteria->compare('rack', $this->rack);
        $criteria->compare('warehouse_id', $this->warehouse_id);
        $criteria->compare('quantity', $this->quantity);
        //$criteria->compare('company_id', Yii::app()->user->master_user_company_id , true);
        //$criteria->compare('company_branch_id', Yii::app()->user->master_user_branch_id);
        if (isset($_POST['stock_id']))
            $criteria->condition = "stock_id=" . $_POST['stock_id'][0];
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.warehouse_id,t.bin,t.rack',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ProductLocation the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function renderQuantity($data, $row) {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(quantity) FROM 
            {{product_location}} 
            where stock_id=" . $data->stock_id . " AND warehouse_id=" . $data->warehouse_id);
        if ($command->queryScalar() > 0)
            return $command->queryScalar();
        else
            return 0;
    }

    public function getTotals($ids) {
        //$ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $total = 0;
            foreach ($ids as $id) {
                $product = Store::model()->findByPk($id);
                $total+=$product->rate * $product->total_quantity;
            }
            return $total;
        }
        else
            return "";
    }

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('stock', 'bin0', 'rack0');
        $criteria->together = true;
        /* if (!empty($this->non_stock_item))
          $criteria->addCondition('non_stock_item="' . $this->non_stock_item . '"', 'AND'); */
        if (!empty($this->not_include_zero_qty) && $this->not_include_zero_qty == "Y")
            $criteria->addCondition('quantity>0  OR stock.non_stock_item="Y"', 'AND');
        if (!empty($this->product_class))
            $criteria->addCondition('stock.product_class_id = ' . $this->product_class, 'AND');
        if (!empty($this->description))
            $criteria->addCondition('stock.description like "%' . $this->description . '%"', 'AND');
        if (!empty($this->generic_name))
            $criteria->addCondition('stock.generic_name like "%' . $this->generic_name . '%"', 'AND');
        if (!empty($this->warehouse))
            $criteria->addCondition('warehouse_id=' . $this->warehouse, 'AND');

        if (!empty($this->from_part_no) && !empty($this->to_part_no)) {
            $criteria->addBetweenCondition('stock.part_number', $this->from_part_no, $this->to_part_no);
        } else if (!empty($this->from_part_no))
            $criteria->addCondition('stock.part_number ="' . $this->from_part_no . '"', 'AND');
        else if (!empty($this->to_part_no))
            $criteria->addCondition('stock.part_number ="' . $this->to_part_no . '"', 'AND');

        if (!empty($this->from_bin) && !empty($this->to_bin)) {
            $criteria->addBetweenCondition('bin0.name', $this->from_bin, $this->to_bin);
        }
        if (!empty($this->from_rack) && !empty($this->to_rack)) {
            $criteria->addBetweenCondition('rack0.name', $this->from_rack, $this->to_rack);
        }
        /*$criteria->addCondition('       stock.company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        stock.company_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'stock.part_number',
            ),
            'pagination' => false
        ));
    }
    public static function getRackBins($warehouse_id='0') {
        $arr_rack=Array();
        $condition = 'rack0.isActive="Y" AND bin0.isActive="Y"';
        if($warehouse_id>0)
        $condition .=' AND warehouse_id ='.$warehouse_id;
        $model = self::model()->with('bin0','rack0')->findAll(array('condition' => $condition));
        foreach($model as $eachmodel){
            $arr_rack[]=array($eachmodel->rack.'/'.$eachmodel->bin=>$eachmodel->rack0->name.'/'.$eachmodel->bin0->name);
        }
        return $arr_rack;
    }
    public function getDropdata() {
        return ($this->warehouse->warehouse_name . '/' . $this->rack0->name .'/'.$this->bin0->name);
    }

        public static function getProductWarehouses($product_id = 0){
       
        $model = self::model()->findAll(array('condition' => 'stock_id = '.$product_id.' ', 'order' => 'is_default_warehouse_id,id'));
        return CHtml::listData($model, 'id', 'dropdata');
    }
   

}
