<?php

/**
 * This is the model class for table "{{mas_pricing_group}}".
 *
 * The followings are the available columns in table '{{mas_pricing_group}}':
 * @property integer $id
 * @property string $pricing_group
 * @property double $percentage
 * string $isActive
 * @property string $addition_deduction
 */
class PricingGroup extends CActiveRecord {
    //public $price_list_file_name;

    /**
     * @return string the associated database table name
     */
    public $file;
    public function tableName() {
        return '{{pricing_group}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('pricing_group', 'required'),
            //array('price_list_file_name', 'required', 'on' => 'base-group'),
            array('pricing_group', 'unique', 'on' => 'add'),
            array('id, parent_id', 'numerical', 'integerOnly' => true),
            array('pricing_group, description, price_list_file_name', 'length', 'max' => 255),
            array('isBasePricingGroup, default_pricing_group, show_in_price_list, isActive, type', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, pricing_group,isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            //'company' => array(self::HAS_MANY, 'Company', 'pricing_group'), 
            'parent' => array(self::BELONGS_TO, 'PricingGroup', 'parent_id'),
            'products' => array(self::HAS_MANY, 'PriceGroupProductRelation', 'price_group_id'),
            'price_list' => array(self::HAS_MANY, 'PriceGroupProductRelation', 'price_group_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'pricing_group' => 'Pricing Group',
            'parent_id' => 'Choose Base price from',
            'description' => 'Description',
            'isActive' => 'Is Active',
            'default_pricing_group' => 'Want to make it as default?',
            'price_list_file_name' => 'price_list_file_name',
            'show_in_price_list' => 'Show In Price List'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('pricinggroup_name'));
        $type = trim(Yii::app()->request->getParam('type'));
        /*$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id . ' 
            AND company_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('pricing_group like "%' . $searchterm . '%"', 'AND');
        if (!empty($type))
            $criteria->addCondition('type = "' . $type . '"', 'AND');
            else
            $criteria->addCondition('type = "S"', 'AND');
            
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 10,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.isBasePricingGroup,t.pricing_group ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasPricingGroup the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getPricingGroupDetailAttrb() {
        return ($this->pricing_group); // . " : " . $this->percentage . '% ' . (($this->addition_deduction == "A") ? "Addition" : "Deduction"));
    }

    public static function getPricingGroup($type = null, $brand_id = null) {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id . ' AND company_branch_id=' . Yii::app()->user->master_user_branch_id;        
        
        $condition = 'isActive="Y"';
        $pricegroups_already_in_this_brand[] = 0;             	
        if ($type != null)        
        {            
        	$condition.= ' AND type="' . $type . '"';        
        }
        if ($brand_id != null) {
            $modelPricegropProduct = PriceGroupProductRelation::model()->findAll('pricing_product_class_id=' . $brand_id);
            foreach ($modelPricegropProduct as $eachOne) {
                $pricegroups_already_in_this_brand[] = $eachOne->price_group_id;
            }

            $pricegroups_already_in_this_brand = implode(',', array_unique($pricegroups_already_in_this_brand));
            $condition .= ' AND id in(' . $pricegroups_already_in_this_brand . ')';
            $condition .= ' OR default_pricing_group="Y" OR parent_id=0';
        }

        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'default_pricing_group'));
        return CHtml::listData($model, 'id', 'pricingGroupDetailAttrb');
    }

    public function getDefaultPricingGroup($type) {
        //$condition = 'default_pricing_group="Y" AND type =  "' . $type . '" AND company_id=' . Yii::app()->user->master_user_company_id . ' AND company_branch_id=' . Yii::app()->user->master_user_branch_id;        $condition = 'default_pricing_group="Y" AND type =  "' . $type . '"';
        return self::model()->find(array('condition' => $condition));
    }

    public function reCalculatePricing($product_id = 0) {
        ini_set("memory_limit", "128G");
        ini_set('max_execution_time', 6000);
        /*$priceGroups = self::model()->findAll(array(
            'condition' => 'company_id=' . Yii::app()->user->master_user_company_id . ' AND company_branch_id=' . Yii::app()->user->master_user_branch_id . ' AND price_list_file_name = ""',
            'order' => 'type DESC, isBasePricingGroup ASC,parent_id ASC'));*/                $priceGroups = self::model()->findAll(array(            'condition' => 'price_list_file_name = ""',            'order' => 'type DESC, isBasePricingGroup ASC,parent_id ASC'));
        foreach ($priceGroups as $eachPriceGroup) {
            //$product_select_condition = 'company_id=' . Yii::app()->user->master_user_company_id . ' AND company_branch_id=' . Yii::app()->user->master_user_branch_id;
            if ($product_id > 0)
                $product_select_condition=' t.id=' . $product_id;
            $productsInThisClass = Store::model()->with('productclass')->findAll($product_select_condition);

            foreach ($productsInThisClass as $eachProduct) {
                $productJustAbove = @PriceGroupProductRelation::model()->find('price_group_id=' . $eachPriceGroup->parent_id  . ' AND store_id=' . $eachProduct->id);
                $exitOrNot = PriceGroupProductRelation::model()->find('price_group_id=' . $eachPriceGroup->id . ' AND store_id=' . $eachProduct->id);
                $percentage = PriceGroupProductRelation::model()->find(array(
                            'condition' => 'price_group_id=' . $eachPriceGroup->id . ' AND pricing_product_class_id=' . $eachProduct->product_class_id,
                            'order' => 'id asc'))->percentage;
                $referringProductRate = ($productJustAbove != null && $productJustAbove->rate > 0) ? $productJustAbove->rate : $eachProduct->rate;
                $eachPercentage = ($percentage > 0) ? $percentage : '100';
                $rateForThisProductUnderThisClass = $referringProductRate * floatval($eachPercentage) / 100;
                if ($exitOrNot != null)
                    $_POST['PriceGroupProductRelation']['id'] = $exitOrNot->id;
                else
                    unset($_POST['PriceGroupProductRelation']['id']);
                $_POST['PriceGroupProductRelation']['price_group_id'] = $eachPriceGroup->id;
                $_POST['PriceGroupProductRelation']['pricing_product_class_id'] = $eachProduct->product_class_id;
                $_POST['PriceGroupProductRelation']['store_id'] = $eachProduct->id;
                $_POST['PriceGroupProductRelation']['rate'] = $rateForThisProductUnderThisClass;
                $_POST['PriceGroupProductRelation']['percentage'] = $eachPercentage;
                $this->commonSave('PriceGroupProductRelation', true);
            }
        }
    }

}
