<?php

/**
 * This is the model class for table "{{order}}".
 *
 * The followings are the available columns in table '{{order}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $file_id
 * @property string $company_id
 * @property integer $contact_id
 * @property string $order_date
 * @property string $delivery_date
 * @property string $sales_group
 * @property string $reference
 * @property string $currency
 * @property double $exchange_rate
 * @property string $payment_terms
 * @property string $shipping_by
 * @property string $lpo
 * @property string $others
 * @property double $net_amount
 * @property double $final_addition_percentage
 * @property double $final_addition_amount
 * @property double $final_deduction_percentage
 * @property double $final_deduction_amount
 * @property double $net_total
 * @property double $grand_total
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property DeliveryNotes[] $deliveryNotes
 * @property User $crmUser
 * @property MasterFile $file
 * @property Company $company
 * @property OrderItem[] $orderItems
 */
class Monitor extends CFormModel {

    /**
     * @return string the associated database table name
     */
    public $company_name;
    public $lead_owner;
    public $contact_name;
    public $date_of_this;
    public $finishing_date;
    public $currency_name;
    public $exchange_rate;

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
           // array('company_id, contact_id, order_date, delivery_date, sales_group,billing_address,shipping_address, currency, exchange_rate, payment_terms,lead_owner_id, shipping_by,title', 'required'),
            
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'contact' => array(self::BELONGS_TO, 'CompanyContact', 'contact_id'),
            'deliveryNotes' => array(self::HAS_MANY, 'DeliveryNotes', 'order_id'),
            'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'company' => array(self::BELONGS_TO, 'Company', 'company_id'),
            'items' => array(self::HAS_MANY, 'OrderItem', 'order_id'),
            'adItems' => array(self::HAS_MANY, 'OrderAddition', 'order_id'),
            'dedItems' => array(self::HAS_MANY, 'OrderDeduction', 'order_id'),
            'netAmount' => array(self::STAT, 'OrderItem', 'order_id', 'select' => 'SUM(net_amount)'),
            'netQuantity' => array(self::STAT, 'OrderItem', 'order_id', 'select' => 'SUM(quantity)'),
            'adTotal' => array(self::STAT, 'OrderAddition', 'order_id', 'select' => 'SUM(calculated_value)'),
            'dedTotal' => array(self::STAT, 'OrderDeduction', 'order_id', 'select' => 'SUM(calculated_value)'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'companycontact' => array(self::BELONGS_TO, 'CompanyContact', 'contact_id'),
            'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'title' => 'File Title',
            'crm_user_id' => 'Crm User',
            'file_id' => 'File',
            'company_name' => 'Company',
            'company_id' => 'Company ID',
            'contact_id' => 'Contact',
            'order_date' => 'Order Date',
            'delivery_date' => 'Delivery Date',
            'sales_group' => 'Sales Group',
            'reference' => 'Reference',
            'currency' => 'Currency',
            'exchange_rate' => 'Exchange Rate',
            'payment_terms' => 'Payment Terms',
            'shipping_by' => 'Shipping By',
            'lpo' => 'LPO',
            'others' => 'Others',
            'net_amount' => 'Net Amount',
            'final_addition_percentage' => 'Final Addition Percentage',
            'final_addition_amount' => 'Final Addition Amount',
            'final_deduction_percentage' => 'Final Deduction Percentage',
            'final_deduction_amount' => 'Final Deduction Amount',
            'net_total' => 'Net Total',
            'grand_total' => 'Grand Total',
            'isActive' => 'Is Active',
            'lead_owner_id' => 'Lead Owner'
        );
    }

    

}
