<?php

/**
 * This is the model class for table "{{meeting}}".
 *
 * The followings are the available columns in table '{{meeting}}':
 * @property string $activity_id
 * @property string $subject
 * @property string $location
 * @property string $participants
 * @property string $additional_participants
 * @property string $start_date
 * @property string $end_date
 * @property string $send_invite
 */
class Meeting extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{meeting}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('subject, location, start_date, end_date', 'required'),
            array('activity_id', 'length', 'max' => 20),
            array('subject, location, participants, internal_participants, additional_participants', 'length', 'max' => 255),
            array('send_invite', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array(
                'end_date',
                'compare',
                'compareAttribute' => 'start_date',
                'operator' => '>=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than "{compareValue}".'
            ),
            array('activity_id, subject, location, participants, additional_participants, start_date, end_date, send_invite,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'activity' => array(self::BELONGS_TO, 'Activity', 'activity_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'activity_id' => 'Activity',
            'subject' => 'Subject',
            'location' => 'Location',
            'participants' => 'Participants',
            'additional_participants' => 'Additional Participants',
            'start_date' => 'Start Date & Time',
            'end_date' => 'End Date & Time',
            'send_invite' => 'Send Invite',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('activity_id', $this->activity_id, true);
        $criteria->compare('subject', $this->subject, true);
        $criteria->compare('location', $this->location, true);
        $criteria->compare('participants', $this->participants, true);
        $criteria->compare('additional_participants', $this->additional_participants, true);
        $criteria->compare('start_date', $this->start_date, true);
        $criteria->compare('end_date', $this->end_date, true);
        $criteria->compare('send_invite', $this->send_invite, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Meeting the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
