<?php

/**
 * This is the model class for table "{{mas_validity}}".
 *
 * The followings are the available columns in table '{{mas_validity}}':
 * @property integer $id
 * @property integer $quotation_validity
 * @property integer $delivery_validity
 * @property integer $order_validity
 */
class MasValidity extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_validity}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('quotation_validity, delivery_validity,lead_validity, order_validity', 'required'),
            array('quotation_validity, delivery_validity, order_validity', 'numerical', 'integerOnly' => true),
            array('terms_and_conditions', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, quotation_validity, delivery_validity, order_validity,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'quotation_validity' => 'Quotation Validity',
            'delivery_validity' => 'Delivery Validity',
            'order_validity' => 'Order Validity',
            'lead_validity' => 'Lead Closing Days'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('quotation_validity', $this->quotation_validity);
        $criteria->compare('delivery_validity', $this->delivery_validity);
        $criteria->compare('order_validity', $this->order_validity);
        //$criteria->compare('company_id', Yii::app()->user->master_user_company_id, true);
        // $criteria->compare('company_branch_id', Yii::app()->user->master_user_branch_id, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasValidity the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
