<?php

/**
 * This is the model class for table "{{mas_company}}".
 *
 * The followings are the available columns in table '{{mas_company}}':
 * @property string $id
 * @property string $alert


 * @property string $isActive
 */
class MasUrl extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_url}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('url,name', 'required'),
            array('url', 'url'),
            array('name, url', 'length', 'max' => 255),

            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('name, url', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'name' => 'Title',
            'url' => 'Website Url',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $searchterm = trim(Yii::app()->request->getParam('searchterm'));
        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('url', $this->url, true);
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.name like "%' . $searchterm . '%" OR 
                                        t.url like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }
   

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompany the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
	
   

}
