<?php

/**
 * This is the model class for table "{{mas_inventory_warehouse}}".
 *
 * The followings are the available columns in table '{{mas_inventory_warehouse}}':
 * @property integer $id
 * @property string $warehouse_name
 * @property string $is_active
 * @property string $is_base_warehouse
 */
class MasInventoryWarehouse extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_inv_warehouse}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('warehouse_name', 'required'),
                        array('warehouse_name', 'unique'),
                        array('warehouse_name', 'filter', 'filter'=>'trim'),
			array('warehouse_name', 'length', 'max'=>255),
			array('isActive, isBaseWareHouse', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, warehouse_name, isActive, isBaseWareHouse,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'warehouse_name' => 'Warehouse Name',
			'isActive' => 'Is Active',
			'isBaseWareHouse' => 'Is Base Warehouse',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('warehouse_name',$this->warehouse_name,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('isBaseWareHouse',$this->isBaseWareHouse,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        public static function getWarehouses() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'warehouse_name ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
     }
      
     public static function getToWarehouses($id) {
        $condition = 'isActive =  "Y" and id !='.$id;
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'warehouse_name ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
     }
     public static function getWarehouse() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'isBaseWareHouse ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
     }

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasInventoryWarehouse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getDefaultWarehouse() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y" AND isBaseWareHouse="Y"';
    	$model = self::model()->find(array('condition' => $condition));
        return $model;
    }
}
