<?php

/**
 * This is the model class for table "{{mas_company_branch}}".
 *
 * The followings are the available columns in table '{{mas_company_branch}}':
 * @property integer $id

 * @property string $branch_code
 * @property string $branch_location
 * @property string $contact_number_1
 * @property string $contact_number_2
 * @property string $mobile_number
 * @property string $fax
 * @property string $email  
 * @property integer $currency_id
 * @property string $skype_id
 * @property string $facbook_link
 * @property string $twitter_link
 * @property string $google_plus
 * @property string $linkedin
 * @property string $instagram
 * @property string $myspace
 * @property string $bill_address1
 * @property string $bill_address2
 * @property string $bill_city
 * @property string $bill_state
 * @property integer $bill_country
 * @property string $bill_pin_or_zip
 * @property string $bill_postal_code
 * @property string $shipp_address1
 * @property string $shipp_address2
 * @property string $shipp_city
 * @property string $shipp_state
 * @property integer $shipp_country
 * @property string $shipp_pin_or_zip
 * @property string $shipp_postal_code
 * @property integer $branch_head_id
 * @property string $branch_head_designation
 * @property string $branch_head_email
 * @property string $branch_head_phno
 * @property string $isActive
 */
class MasCompanyBranch extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $branch_head_name;
    public $currency_name;

    public function tableName() {
        return '{{mas_company_branch}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('company_id, branch_code,branch_name, branch_location, currency_id,  bill_address1, bill_country, shipp_address1, 
                            shipp_country, branch_head_designation, branch_head_email', 'required'),
            array(' currency_id, bill_country, shipp_country, branch_head_id', 'numerical', 'integerOnly' => true),
            array('branch_code,branch_name, branch_location, contact_number_1, contact_number_2, mobile_number, fax, email, 
                            skype_id, facbook_link, twitter_link, google_plus, linkedin, youtube,instagram, myspace, bill_address1, bill_address2, 
                            bill_city, bill_state, bill_pin_or_zip, bill_postal_code, shipp_address1, shipp_address2, shipp_city, shipp_state,
                            shipp_pin_or_zip, shipp_postal_code,branch_head_phno, branch_head_designation, branch_head_email', 'length', 'max' => 255),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,  branch_code, branch_location, contact_number_1, contact_number_2, mobile_number, fax, email, currency_id, 
                            skype_id, facbook_link, twitter_link, google_plus, linkedin, instagram, myspace, bill_address1, bill_address2, 
                            bill_city, bill_state, bill_country, bill_pin_or_zip, bill_postal_code, shipp_address1, shipp_address2, shipp_city, 
                            shipp_state, shipp_country, shipp_pin_or_zip, shipp_postal_code, branch_head_id, branch_head_designation, branch_head_email, 
                            branch_head_phno, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'baseCurrency'=>array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'branchhead'=>array(self::BELONGS_TO, 'User', 'branch_head_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'branch_code' => 'Branch Code',
            'branch_name' => 'Branch Name',
            'branch_location' => 'Branch Location',
            'contact_number_1' => 'Phone 1',
            'contact_number_2' => 'Phone 2',
            'mobile_number' => 'Mobile Number',
            'fax' => 'Fax',
            'email' => 'E-mail',
            'currency_id' => 'Base Currency',
            'skype_id' => 'Skype',
            'facbook_link' => 'Facbook Link',
            'twitter_link' => 'Twitter Link',
            'google_plus' => 'Google Plus',
            'linkedin' => 'Linkedin',
            'instagram' => 'Instagram',
            'myspace' => 'Myspace',
            'bill_address1' => 'Billing Address1',
            'bill_address2' => 'Billing Address2',
            'bill_city' => 'Billing City',
            'bill_state' => 'Billing State',
            'bill_country' => 'Billing Country',
            'bill_pin_or_zip' => 'Billing Pin Or Zip',
            'bill_postal_code' => 'Billing Postal Code',
            'shipp_address1' => 'Shipping Address1',
            'shipp_address2' => 'Shipping Address2',
            'shipp_city' => 'Shipping City',
            'shipp_state' => 'Shipping State',
            'shipp_country' => 'Shipping Country',
            'shipp_pin_or_zip' => 'Shipping Pin Or Zip',
            'shipp_postal_code' => 'Shipping Postal Code',
            'branch_head_id' => 'Branch Head',
            'branch_head_designation' => 'Designation',
            'branch_head_email' => 'Email',
            'branch_head_phno' => 'Phone No.',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);

        $criteria->compare('branch_code', $this->branch_code, true);
        $criteria->compare('branch_location', $this->branch_location, true);
        $criteria->compare('contact_number_1', $this->contact_number_1, true);
        $criteria->compare('contact_number_2', $this->contact_number_2, true);
        $criteria->compare('mobile_number', $this->mobile_number, true);
        $criteria->compare('fax', $this->fax, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('currency_id', $this->currency_id);
        $criteria->compare('skype_id', $this->skype_id, true);
        $criteria->compare('facbook_link', $this->facbook_link, true);
        $criteria->compare('twitter_link', $this->twitter_link, true);
        $criteria->compare('google_plus', $this->google_plus, true);
        $criteria->compare('linkedin', $this->linkedin, true);
        $criteria->compare('instagram', $this->instagram, true);
        $criteria->compare('myspace', $this->myspace, true);
        $criteria->compare('bill_address1', $this->bill_address1, true);
        $criteria->compare('bill_address2', $this->bill_address2, true);
        $criteria->compare('bill_city', $this->bill_city, true);
        $criteria->compare('bill_state', $this->bill_state, true);
        $criteria->compare('bill_country', $this->bill_country);
        $criteria->compare('bill_pin_or_zip', $this->bill_pin_or_zip, true);
        $criteria->compare('bill_postal_code', $this->bill_postal_code, true);
        $criteria->compare('shipp_address1', $this->shipp_address1, true);
        $criteria->compare('shipp_address2', $this->shipp_address2, true);
        $criteria->compare('shipp_city', $this->shipp_city, true);
        $criteria->compare('shipp_state', $this->shipp_state, true);
        $criteria->compare('shipp_country', $this->shipp_country);
        $criteria->compare('shipp_pin_or_zip', $this->shipp_pin_or_zip, true);
        $criteria->compare('shipp_postal_code', $this->shipp_postal_code, true);
        $criteria->compare('branch_head_id', $this->branch_head_id);
        $criteria->compare('branch_head_designation', $this->branch_head_designation, true);
        $criteria->compare('branch_head_email', $this->branch_head_email, true);
        $criteria->compare('branch_head_phno', $this->branch_head_phno, true);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.branch_code ASC',
            ),
        ));
    }
     public function getShippingAddress() {
        $address = array();
        $address[] = $this->shipp_address1;
        /*$address[] = $this->shipping_city;
        $address[] = $this->shipping_postalcode;
        $address[] = $this->shipping_state;
        $address[] = $this->shipping_country;
        $address[] = $this->shipping_pinzip;*/
        return (implode(', ', array_filter($address)));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompanyBranch the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getCompanyBranches($id = null) {
        $condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        if ($id != null)
        {
            $condition .= ' AND id=' . $id;
            $arr_company_branch = self::model()->findAll(array('condition' => $condition));
            return $arr_company_branch;
        }
        else
        {    
	        $model = self::model()->findAll(array('condition' => $condition));
	        return CHtml::listData($model, 'id', 'branch_code');
        }
    }

    public function getBillingAddress() {
        $address = array();
        $address[] = $this->bill_address1;
        $address[] = $this->bill_address2;
        /*$address[] = $this->shipping_city;
        $address[] = $this->shipping_postalcode;
        $address[] = $this->shipping_state;
        $address[] = $this->shipping_country;
        $address[] = $this->shipping_pinzip;*/
        return (implode(', ', array_filter($address)));
    }
}
