<?php

/**
 * This is the model class for table "{{invoice_item}}".
 *
 * The followings are the available columns in table '{{invoice_item}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $invoice_id
 * @property string $description
 * @property double $quantity
 * @property integer $unit
 * @property double $rate
 * @property double $amount
 * @property double $addition_percentage
 * @property double $addition_amount
 * @property double $deduction_percentage
 * @property double $deduction_amount
 * @property double $net_amount
 *
 * The followings are the available model relations:
 * @property Invoice $invoice
 * @property Store $product
 */
class InvoiceItem extends CActiveRecord {

    public $product_name;
    public $unit;
    public $searchstartdate;
    public $searchenddate;
    public $product_class_id;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{invoice_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, description, quantity, rate, amount, net_amount', 'required'),
            array('id, product_id, invoice_id', 'numerical', 'integerOnly' => true),
            array('quantity, rate, amount, addition_amount, deduction_amount, net_amount,cost_rate,tax_vat_percentage,tax_vat_amount', 'numerical'),
            array('addition_percentage, deduction_percentage', 'length', 'max' => 50),
            array(
                'rate',
                'compare',
                'compareValue' => 0,
                'operator' => '>',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than "{compareValue}".'
            ),
            array(
                'net_amount',
                'compare',
                'compareValue' => 0,
                'operator' => '>=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than or equal to "{compareValue}".'
            ),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, product_id, invoice_id, description, quantity, unit, rate, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, net_amount', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'invoice' => array(self::BELONGS_TO, 'Invoice', 'invoice_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unit' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'invoiceunit' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_id' => 'Product',
            'invoice_id' => 'Invoice',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'rate' => 'Rate',
            'amount' => 'Amount',
            'addition_percentage' => 'Addition Percentage',
            'addition_amount' => 'Addition Amount',
            'deduction_percentage' => 'Deduction Percentage',
            'deduction_amount' => 'Deduction Amount',
            'net_amount' => 'Net Amount',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        if (isset($_GET['invoice_id']))// if isadmin
            $criteria->condition = "quantity>0 AND invoice_id=" . (int) $_GET['invoice_id'][0];
        // if (isset($_POST['product_id']))// if isadmin
        //     $criteria->condition = "product_id=" . (int) $_POST['product_id'];

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function generatesaleshistory() {
        $criteria = new CDbCriteria;
        if (isset($_POST['product_id']))// if isadmin
            $criteria->condition = "product_id=" . (int) $_POST['product_id'];
        $criteria->with = array('invoice');
        if (isset($_POST['sales_hist_start_date']) && isset($_POST['sales_hist_end_date']) && isset($_POST['sales_history_product_id']))
            $criteria->condition .= 'product_id   = "' . $_POST['sales_history_product_id'] . '" AND invoice.invoice_date BETWEEN "' . $_POST['sales_hist_start_date'] . '" AND "' . $_POST['sales_hist_end_date'] . '"';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'invoice.invoice_date DESC',
            ),
            'pagination' => array('pageSize' => 10)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InvoiceItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
