<?php

/**
 * This is the model class for table "{{inventory_transfer}}".
 *
 * The followings are the available columns in table '{{inventory_transfer}}':
 * @property string $id
 * @property string $stock_id
 * @property string $from_warehouse_id
 * @property string $to_warehouse_id
 * @property string $to_bin_id
 * @property string $to_rack_id
 * @property string $reference
 * @property string $transfer_date
 */
class InventoryTransfer extends CActiveRecord {

    public $from_warehouse_name;
    public $to_warehouse_name;
    public $to_bin_name;
    public $store_product_name;
    public $to_rack_name;
    public $item_description;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{inventory_transfer}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('stock_id, from_warehouse_id, to_warehouse_id,   quantity', 'required'),
            array('stock_id, from_warehouse_id, to_warehouse_id, to_bin_id, to_rack_id', 'length', 'max' => 20),
            array('reference', 'length', 'max' => 255),
            array('description', 'length', 'max' => 5000),
            array('quantity', 'numerical'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, stock_id, from_warehouse_id, to_warehouse_id, to_bin_id, to_rack_id, reference, transfer_date', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'stock' => array(self::BELONGS_TO, 'Store', 'stock_id'),
            'warehouseTo' => array(self::BELONGS_TO, 'MasInvWarehouse', 'to_warehouse_id'),
            'warehouseFrom' => array(self::BELONGS_TO, 'MasInvWarehouse', 'from_warehouse_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'stock_id' => 'Item',
            'from_warehouse_id' => 'From Warehouse',
            'to_warehouse_id' => 'To Warehouse',
            'to_bin_id' => 'To Bin',
            'to_rack_id' => 'To Rack',
            'reference' => 'Reference',
            'transfer_date' => 'Transfer Date',
            'quantity' => 'Transfer Quantity'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('stock_id', $this->stock_id, true);
        $criteria->compare('from_warehouse_id', $this->from_warehouse_id, true);
        $criteria->compare('to_warehouse_id', $this->to_warehouse_id, true);
        $criteria->compare('to_bin_id', $this->to_bin_id, true);
        $criteria->compare('to_rack_id', $this->to_rack_id, true);
        $criteria->compare('reference', $this->reference, true);
        $criteria->compare('transfer_date', $this->transfer_date, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.transfer_date,t.from_warehouse_id',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InventoryTransfer the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
