<?php
class InventorySettings extends CActiveRecord {

    public function tableName() {
        return '{{inventory_settings}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('include_freight_in_average_costing', 'required'),
            array('include_freight_in_average_costing', 'length', 'max' => 1),
            array('id, include_freight_in_average_costing,cost_averaging_done_in,stock_quantity_updation_done_in', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'include_freight_in_average_costing' => 'Additions / Deductions to affect average cost',
            'cost_averaging_done_in' => 'Cost Averaging',
            'stock_quantity_updation_done_in' => 'Stock Updation',
        );
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
