<?php

/**
 * This is the model class for table "{{inventory_material_distribution}}".
 *
 * The followings are the available columns in table '{{inventory_material_distribution}}':
 * @property string $id
 * @property string $from_store_id
 * @property string $to_store_id
 * @property double $quantity
 * @property string $done_by
 * @property string $done_date
 */
class InventoryMaterialDistribution extends CActiveRecord {

    public $rate;
    public $searchstartdate;
    public $searchenddate;
    public $product_class_id;
    public $product_id;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{inventory_material_distribution}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('from_store_id,from_warehouse_id, from_quantity, to_store_id, to_warehouse_id, quantity, done_by, done_date', 'required'),
            array('quantity', 'numerical'),
            array('from_store_id, to_store_id, done_by', 'length', 'max' => 20),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, from_store_id, to_store_id, quantity, done_by, done_date', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'doneBy' => array(self::BELONGS_TO, 'User', 'done_by'),
            'fromPart' => array(self::BELONGS_TO, 'Store', 'from_store_id'),
            'toPart' => array(self::BELONGS_TO, 'Store', 'to_store_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'from_store_id' => 'From Item',
            'from_warehouse_id' => 'From Warehouse',
            'from_quantity' => 'From quantity',
            'to_store_id' => 'To Item',
            'to_warehouse_id' => 'To Warehouse',
            'quantity' => 'Quantity to be distributed',
            'done_by' => 'Done By',
            'done_date' => 'Done Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('from_store_id', $this->from_store_id, true);
        $criteria->compare('to_store_id', $this->to_store_id, true);
        $criteria->compare('quantity', $this->quantity);
        $criteria->compare('done_by', $this->done_by, true);
        $criteria->compare('done_date', $this->done_date, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InventoryMaterialDistribution the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('fromPart', 'toPart');
        if (!empty($this->product_class_id))
            $criteria->addCondition('fromPart.product_class_id = ' . $this->product_class_id.' OR toPart.product_class_id = ' . $this->product_class_id, 'AND');
        if (!empty($this->product_id))
            $criteria->addCondition('t.from_store_id = ' . $this->product_id . ' OR t.to_store_id = ' . $this->product_id, 'AND');
        //if (!empty($this->from_part_no) && !empty($this->to_part_no)) {
        $criteria->addBetweenCondition('done_date', $this->searchstartdate, $this->searchenddate);
        //} 
        /*$criteria->addCondition('       fromPart.company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        fromPart.company_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'done_date DESC,fromPart.part_number',
            ),
            'pagination' => false
        ));
    }

}
