<?php

/**
 * This is the model class for table "{{inventory_log}}".
 *
 * The followings are the available columns in table '{{inventory_log}}':
 * @property integer $id
 * @property integer $product_id
 * @property string $previous_rate
 * @property string $new_rate
 * @property integer $crm_user_id
 * @property string $date
 */
class InventoryLog extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{inventory_log}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, previous_rate, new_rate, crm_user_id', 'required'),
            array('product_id, crm_user_id', 'numerical', 'integerOnly' => true),
            array('previous_rate, new_rate', 'length', 'max' => 15),
            array('reason', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, product_id, previous_rate, new_rate, crm_user_id, date,reason', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_id' => 'Product',
            'previous_rate' => 'Previous Rate',
            'new_rate' => 'New Rate',
            'crm_user_id' => 'Crm User',
            'date' => 'Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('previous_rate', $this->previous_rate, true);
        $criteria->compare('new_rate', $this->new_rate, true);
        $criteria->compare('crm_user_id', $this->crm_user_id);
        $criteria->compare('date', $this->date, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InventoryLog the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
