<?php

/**
 * This is the model class for table "crm_form_boq_item".
 *
 * The followings are the available columns in table 'crm_form_boq_item':
 * @property integer $id
 * @property string $tag_no
 * @property string $equipment_description
 * @property string $model
 * @property string $capacity_dimension
 * @property string $material
 * @property string $Quantity
 * @property string $make
 * @property string $power_supply
 * @property string $remarks1
 * @property string $accessories
 * @property string $spare_parts
 * @property string $remarks
 * @property string $connections
 * @property string $output_digital_analog
 * @property string $wetted_parts
 * @property string $range_min_max
 * @property string $measuring_unit
 * @property string $line_material
 * @property string $display_local_panel
 * @property string $pipe_diameter
 * @property string $volume
 * @property string $cylindrical_or_rectangular
 * @property string $horizontal_or_vertical
 * @property string $service_liquid
 * @property string $graduation_scale
 * @property string $flow_and_pressure
 * @property string $impeller_diaphragm_moc
 * @property string $casing_moc
 * @property string $end_conection
 * @property string $pump_type
 * @property string $motor_specs
 * @property string $valve_size
 * @property string $valve_end_connection
 * @property string $actuator_type
 * @property string $mot_actuator_nor_open_nor_close
 * @property string $pneu_actuator_sing_or_doub_acting
 * @property string $moc_body_internal
 * @property string $pressure_rating
 * @property string $limit_switches
 * @property string $created_date
 */
class FormBoqGeneralItem extends CActiveRecord
{
        public $product_name;
        public $unit_symbol;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		 return '{{form_boq_general_item}}';
                
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('tag_no, equipment_description, model, capacity_dimension, material, Quantity, make, power_supply, remarks1, accessories, spare_parts, remarks, connections, output_digital_analog, wetted_parts, range_min_max, measuring_unit, line_material, display_local_panel, pipe_diameter, volume, cylindrical_or_rectangular, horizontal_or_vertical, service_liquid, graduation_scale, flow_and_pressure, impeller_diaphragm_moc, casing_moc, end_conection, pump_type, motor_specs, valve_size, valve_end_connection, actuator_type, mot_actuator_nor_open_nor_close, pneu_actuator_sing_or_doub_acting, moc_body_internal, pressure_rating, limit_switches, created_date', 'required'),
			//array('item_no','required'),
                        array('tag_no,product_id,product_name,item_no,picked_color,description, model, capacity_dimension, material, quantity,unit, make, power_supply, remarks1, accessories, spare_parts, remarks, connections, output_digital_analog, wetted_parts, range_min_max, measuring_unit, line_material, display_local_panel, pipe_diameter, volume, cylindrical_or_rectangular, horizontal_or_vertical, service_liquid, graduation_scale, flow_and_pressure, impeller_diaphragm_moc, casing_moc, end_conection, pump_type, motor_specs, valve_size, valve_end_connection, actuator_type, mot_actuator_nor_open_nor_close, pneu_actuator_sing_or_doub_acting, moc_body_internal, pressure_rating, limit_switches,manual,panel,notes,consumables,quantity_per_po,spare_description', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
                        array('item_no,category_id','safe'),
			array('id,item_no,picked_color,revision,form_boq_id, tag_no,description, model, capacity_dimension, material, quantity, make, power_supply, remarks1, accessories, spare_parts, remarks, connections, output_digital_analog, wetted_parts, range_min_max, measuring_unit, line_material, display_local_panel, pipe_diameter, volume, cylindrical_or_rectangular, horizontal_or_vertical, service_liquid, graduation_scale, flow_and_pressure, impeller_diaphragm_moc, casing_moc, end_conection, pump_type, motor_specs, valve_size, valve_end_connection, actuator_type, mot_actuator_nor_open_nor_close, pneu_actuator_sing_or_doub_acting, moc_body_internal, pressure_rating, limit_switches,manual,panel,notes,consumables,quantity_per_po,spare_description, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'boqgeneral' => array(self::BELONGS_TO, 'Quotes', 'form_boq_id'),
                    'item' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'unitsymbol' => array(self::BELONGS_TO, 'Unit', 'unit'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
                        'item_no' => 'Item No.',
			'tag_no' => 'Tag No',
			'description' => 'Description',
			'model' => 'Model',
			'capacity_dimension' => 'Capacity Dimension',
			'material' => 'Material',
			'quantity' => 'Quantity',
			'make' => 'Make',
			'power_supply' => 'Power Supply',
			'remarks1' => 'Remarks1',
			'accessories' => 'Accessories',
			'spare_parts' => 'Spare Parts',
			'remarks' => 'Remarks',
			'connections' => 'Connections',
			'output_digital_analog' => 'Output Digital Analog',
			'wetted_parts' => 'Wetted Parts',
			'range_min_max' => 'Range Min Max',
			'measuring_unit' => 'Measuring Unit',
			'line_material' => 'Line Material',
			'display_local_panel' => 'Display Local Panel',
			'pipe_diameter' => 'Pipe Diameter',
			'volume' => 'Volume',
			'cylindrical_or_rectangular' => 'Cylindrical Or Rectangular',
			'horizontal_or_vertical' => 'Horizontal Or Vertical',
			'service_liquid' => 'Service Liquid',
			'graduation_scale' => 'Graduation Scale',
			'flow_and_pressure' => 'Flow And Pressure',
			'impeller_diaphragm_moc' => 'Impeller Diaphragm Moc',
			'casing_moc' => 'Casing Moc',
			'end_conection' => 'End Conection',
			'pump_type' => 'Pump Type',
			'motor_specs' => 'Motor Specs',
			'valve_size' => 'Valve Size',
			'valve_end_connection' => 'Valve End Connection',
			'actuator_type' => 'Actuator Type',
			'mot_actuator_nor_open_nor_close' => 'Mot Actuator Nor Open Nor Close',
			'pneu_actuator_sing_or_doub_acting' => 'Pneu Actuator Sing Or Doub Acting',
			'moc_body_internal' => 'Moc Body Internal',
			'pressure_rating' => 'Pressure Rating',
			'limit_switches' => 'Limit Switches',
                        'manual' => 'Manual',
                        'panel' => 'Panel',
                        'consumables'=>'Consumables',
                        'quantity_per_po'=>'Quantity Per Po',
                        'spare_description'=>"Spare Description",
                        'notes' => 'Notes',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tag_no',$this->tag_no,true);
		$criteria->compare('equipment_description',$this->equipment_description,true);
		$criteria->compare('model',$this->model,true);
		$criteria->compare('capacity_dimension',$this->capacity_dimension,true);
		$criteria->compare('material',$this->material,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('make',$this->make,true);
		$criteria->compare('power_supply',$this->power_supply,true);
		$criteria->compare('remarks1',$this->remarks1,true);
		$criteria->compare('accessories',$this->accessories,true);
		$criteria->compare('spare_parts',$this->spare_parts,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('connections',$this->connections,true);
		$criteria->compare('output_digital_analog',$this->output_digital_analog,true);
		$criteria->compare('wetted_parts',$this->wetted_parts,true);
		$criteria->compare('range_min_max',$this->range_min_max,true);
		$criteria->compare('measuring_unit',$this->measuring_unit,true);
		$criteria->compare('line_material',$this->line_material,true);
		$criteria->compare('display_local_panel',$this->display_local_panel,true);
		$criteria->compare('pipe_diameter',$this->pipe_diameter,true);
		$criteria->compare('volume',$this->volume,true);
		$criteria->compare('cylindrical_or_rectangular',$this->cylindrical_or_rectangular,true);
		$criteria->compare('horizontal_or_vertical',$this->horizontal_or_vertical,true);
		$criteria->compare('service_liquid',$this->service_liquid,true);
		$criteria->compare('graduation_scale',$this->graduation_scale,true);
		$criteria->compare('flow_and_pressure',$this->flow_and_pressure,true);
		$criteria->compare('impeller_diaphragm_moc',$this->impeller_diaphragm_moc,true);
		$criteria->compare('casing_moc',$this->casing_moc,true);
		$criteria->compare('end_conection',$this->end_conection,true);
		$criteria->compare('pump_type',$this->pump_type,true);
		$criteria->compare('motor_specs',$this->motor_specs,true);
		$criteria->compare('valve_size',$this->valve_size,true);
		$criteria->compare('valve_end_connection',$this->valve_end_connection,true);
		$criteria->compare('actuator_type',$this->actuator_type,true);
		$criteria->compare('mot_actuator_nor_open_nor_close',$this->mot_actuator_nor_open_nor_close,true);
		$criteria->compare('pneu_actuator_sing_or_doub_acting',$this->pneu_actuator_sing_or_doub_acting,true);
		$criteria->compare('moc_body_internal',$this->moc_body_internal,true);
		$criteria->compare('pressure_rating',$this->pressure_rating,true);
		$criteria->compare('limit_switches',$this->limit_switches,true);
                $criteria->compare('manual',$this->manual,true);
                $criteria->compare('panel',$this->panel,true);
                $criteria->compare('notes',$this->notes,true);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CrmFormBoqItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
