<?php

/**
 * This is the model class for table "{{footer_items}}".
 *
 * The followings are the available columns in table '{{footer_items}}':
 * @property integer $id
 * @property integer $sales_purchase_type
 * @property integer $item_type
 * @property string $item_name
 */
class FooterItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{footer_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sales_purchase_type, item_type, item_name,fin_account_id', 'required'),
			array('sales_purchase_type, item_type', 'numerical', 'integerOnly'=>true),
			array('item_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, sales_purchase_type, item_type, item_name,fin_account_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'fin_account' => array(self::BELONGS_TO, 'FinAccounts', 'fin_account_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'sales_purchase_type' => 'Sales/Purchase',
			'item_type' => 'Type',
			'item_name' => 'Description',
			'fin_account_id' => 'Accounts',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('sales_purchase_type',$this->sales_purchase_type);
		$criteria->compare('item_type',$this->item_type);
		$criteria->compare('item_name',$this->item_name,true);
		$criteria->compare('fin_account_id',$this->fin_account_id,true);
		$criteria->with		=	'fin_account';
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('footeritem_search')) : $searchterm;

        if (!empty($searchterm)) {
            $criteria->addCondition('item_name like "%' . $searchterm . '%" OR fin_account_id like "%' . $searchterm . '%"', 'AND');
        }

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.item_name',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 100) : false
        ));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FooterItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getSalesAdditions() {
		$condition = 'sales_purchase_type =1 AND item_type=1';
		$model = self::model()->findAll(array('condition' => $condition,'order' => 'item_name'));
		return CHtml::listData($model, 'id', 'item_name');
	}
	
	public static function getSalesDeductions() {
		$condition = 'sales_purchase_type =1 AND item_type=2';
		$model = self::model()->findAll(array('condition' => $condition,'order' => 'item_name'));
		return CHtml::listData($model, 'id', 'item_name');
	}
	
	public static function getPurchaseAdditions() {
		$condition = 'sales_purchase_type =2 AND item_type=1';
		$model = self::model()->findAll(array('condition' => $condition,'order' => 'item_name'));
		return CHtml::listData($model, 'id', 'item_name');
	}
	
	public static function getPurchaseDeductions() {
		$condition = 'sales_purchase_type =2 AND item_type=2';
		$model = self::model()->findAll(array('condition' => $condition,'order' => 'item_name'));
		return CHtml::listData($model, 'id', 'item_name');
	}
	
	public static function getFooterItemName($particular_id=0) {
	    if($particular_id > 0){
    		$model = self::model()->findByPk($particular_id);
    		return $model->item_name;
	    }
	    else
	    {
	        return "";
	    }
	}
	
	
}
