<?php

/**
 * This is the model class for table "{{customers}}".
 *
 * The followings are the available columns in table '{{customers}}':
 * @property string $id
 * @property integer $bank_id
 * @property string $bank_name
 *
 */
class FooterItem extends CActiveRecord {

    /**

     * @return string the associated database table name

     */
    public function tableName() {
        return '{{footer_items}}';
    }

    /**

     * @return array validation rules for model attributes.

     */
    public function rules() {

        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.

        return array(
            array('sales_purchase_type, item_type, item_name', 'required'),            
            
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, sales_purchase_type, item_type, item_name,description', 'safe', 'on' => 'search'),
        );
    }

    /**

     * @return array relational rules.

     */
    public function relations() {

        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**

     * @return array customized attribute labels (name=>label)

     */
    public function attributeLabels() {

        return array(
            'id' => 'ID',
            'sales_purchase_type' => 'Sales/Purchase Type',
            'item_type' => 'Item Type',
            'item_name' => 'Item Name',
        );
    }


	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);		
		$criteria->compare('sales_purchase_type',$this->sales_purchase_type);
                $criteria->compare('item_type',$this->item_type);
                $criteria->compare('item_name',$this->item_name);
		

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Customers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public static function getFooterItems()
        {
                 //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
                 $condition = '';
                 $model = self::model()->findAll(array('condition' => $condition));
                 return CHtml::listData($model, 'id', 'item_name');
        }
        public static function getPurchaseAdditions() {
		$condition = 'sales_purchase_type = 2 AND item_type=1';
		$model = self::model()->findAll(array('condition' => $condition,'order' => 'item_name'));
		return CHtml::listData($model, 'id', 'item_name');
	}
	
	public static function getPurchaseDeductions() {
		$condition = 'sales_purchase_type =2 AND item_type=2';
		$model = self::model()->findAll(array('condition' => $condition,'order' => 'item_name'));
		return CHtml::listData($model, 'id', 'item_name');
    }
    public static function getFooterItemsDes()
        {
                 //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
                 $condition = '';
                 $model = self::model()->findAll(array('condition' => $condition));
                 return CHtml::listData($model, 'id', 'description');
        }
}

