<?php

/**
 * This is the model class for table "crm_fin_voucher_allocation_head".
 *
 * The followings are the available columns in table 'crm_fin_voucher_allocation_head':
 * @property integer $id
 * @property string $date
 * @property integer $voucher_type
 * @property integer $debit_subledger_id
 * @property integer $credit_subledger_id
 */
class FinVoucherAllocationHead extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FinVoucherAllocationHead the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fin_voucher_allocation_head}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('alloc_date, main,credit,debit', 'required'),
			array('main,subledger', 'numerical', 'integerOnly'=>true),
                    array('vouchers,policy', 'length', 'max' => 25555),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('main,subledger', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
//                    'amount' => array(self::STAT, 'FinVoucherAllocation', 'allocation_id', 'select' => 'SUM(credit_allocate_amount)'),
                    'sub' => array(self::BELONGS_TO, 'Subledger', 'subledger'),
                    'account' => array(self::BELONGS_TO, 'FinAccounts', 'main'),          
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'alloc_date' => 'Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
        $search = trim(Yii::app()->request->getParam('search'));
        $allocate = trim(Yii::app()->request->getParam('allocate'));
		$criteria=new CDbCriteria;
//        $criteria->with = array('account','sub');
		
        $criteria->addCondition('t.isActive="Y"', 'AND');
        if($search){
                $criteria->addCondition('t.id like "%'.$search.'%" OR t.policy like "%'.$search.'%" OR t.vouchers like "%'.$search.'%"','AND');
        }
          if($allocate=='')
                 {
                     $allocate="Y";
                 }
         if($allocate)
			      {
			      $criteria->addCondition('t.isActive="'.$allocate.'"', 'AND');
			      }
        $start_date 	= trim(Yii::app()->request->getParam('start_date'));
        $end_date 		= trim(Yii::app()->request->getParam('end_date'));
         
        $current_date = date('Y-m-d');
         
        if($start_date!="" && $end_date!="")
        {
        
        	$arr_start_date = explode("/",$start_date);
        
        	$start_date = $arr_start_date[2]."-".$arr_start_date[1]."-".$arr_start_date[0];
        
        	$arr_end_date = explode("/",$end_date);
        
        	$end_date = $arr_end_date[2]."-".$arr_end_date[1]."-".$arr_end_date[0];
        
        	$criteria->addCondition('alloc_date>="'.$start_date.'" AND alloc_date<="'.$end_date.'"', 'AND');
        }
        else
        {
        	$criteria->addCondition('alloc_date="'.$current_date.'"', 'AND');
        	$criteria->limit = 5;
        }
        
        
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
                    'pagination' => false,
		));
	}
        
//    public function searchReceiptAllocation()
//	{
//		// Warning: Please modify the following code to remove attributes that
//		// should not be searched.
//        $search = trim(Yii::app()->request->getParam('search'));
//           $allocate = trim(Yii::app()->request->getParam('allocate'));
//		$criteria=new CDbCriteria;
//
//		$criteria->compare('id',$this->id);
//		$criteria->compare('date',$this->date,true);
//		$criteria->compare('voucher_type',$this->voucher_type);
//		$criteria->compare('debit_subledger_id',$this->debit_subledger_id);
//		$criteria->compare('credit_subledger_id',$this->credit_subledger_id);
//        $criteria->addCondition('voucher_type=2 AND isActive="Y"', 'AND');
//        
//          if($allocate=='')
//                 {
//                     $allocate="N";
//                 }
//         if($allocate)
//			      {
//			      $criteria->addCondition('t.isActive="'.$allocate.'"', 'AND');
//			      }
//        $current_date = date('Y-m-d');
//         
//        if($start_date!="" && $end_date!="")
//        {
//        
//        	$arr_start_date = explode("/",$start_date);
//        
//        	$start_date = $arr_start_date[2]."-".$arr_start_date[1]."-".$arr_start_date[0];
//        
//        	$arr_end_date = explode("/",$end_date);
//        
//        	$end_date = $arr_end_date[2]."-".$arr_end_date[1]."-".$arr_end_date[0];
//        
//        	$criteria->addCondition('date>="'.$start_date.'" AND date<="'.$end_date.'"', 'AND');
//        }
////        else
////        {
////        	$criteria->addCondition('date="'.$current_date.'"', 'AND');
////        	$criteria->limit = 5;
////        }
//        
//		return new CActiveDataProvider($this, array(
//			'criteria'=>$criteria,
//                    'pagination' => false,
//		));
//	}
        
//    public static function type($data)
//    {
//    
//     switch ($data->voucher_type)
//     {
//      case 1:
//          return "Payable";
//          break;
//      case 2:
//          return "Receivable";
//          break;
//           }
//    }
}