<?php

/**
 * This is the model class for table "{{mas_bank}}".
 *
 * The followings are the available columns in table '{{mas_bank}}':
 * @property integer $id
 * @property string $bank_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class FinVendorAccount extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $adtndedtn;

    public function tableName() {
        return '{{fin_vendor_account}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
          //  array('account_no', 'required'),
            ///   array('bank_name', 'length', 'max' => 255),
            //array('account_no', 'unique', 'on' => 'add'),
            //array('account_no,description,adtndedtn', 'required', 'on' => 'adtndedtn'),
           // array('account_no', 'unique', 'on' => 'adtndedtn'),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, date,ref_id,vendor_id,credit,debit,ref_type,isActive', 'safe', 'on' => 'search'),
            array('id, date,ref_id,vendor_id,credit,debit,ref_type,isActive', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
                //   'masCompanies' => array(self::HAS_MANY, 'MasCompany', 'bank'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            // 'bank_name' => 'Bank Name',
            'isActive' => 'Is Active',
            'adtndedtn' => 'Addition/Deduction'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('account_no'));
        $criteria->addCondition('logistics_type="O" and isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('account_no like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.account_no ASC',
            ),
        ));
    }

    public function searchadtndedtn() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('account_no'));
        $criteria->addCondition(' isActive =  "Y" AND (logistics_type="A" OR logistics_type="D")  AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('account_no like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.account_no ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }


}

