<?php

/**
 * This is the model class for table "{{fin_outstanding_invoices}}".
 *
 * The followings are the available columns in table '{{fin_outstanding_invoices}}':
 * @property integer $id
 * @property string $invoice_reference
 * @property string $amount
 * @property integer $customer_vendor_id
 * @property integer $customer_vendor_id
 * @property integer $created_by
 * @property integer $created_date_time
 */
class FinOutstandingInvoices extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */


	public $name;
	public function tableName()
	{
		return '{{fin_outstanding_invoices}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('invoice_reference, invoice_date, amount, customer_vendor_id, customer_vendor_id', 'required'),
			array('customer_vendor_id, customer_vendor_id, created_by', 'numerical', 'integerOnly'=>true),
			array('invoice_reference', 'length', 'max'=>255),
			array('amount', 'length', 'max'=>14),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, invoice_reference, invoice_date, amount, customer_vendor_id, customer_vendor_id, created_by, created_date_time,synced', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically geneamountd below.
		return array(
			'customer_details' => array(self::BELONGS_TO, 'Customer', 'customer_vendor_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'invoice_reference' => 'Invoice Reference',
			'amount' => 'amount',
			'customer_vendor_id' => 'Customer Vendor',
			'customer_vendor_id' => 'Customer Vendor Type',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('invoice_reference',$this->invoice_reference,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('customer_vendor_id',$this->customer_vendor_id);
		$criteria->compare('customer_vendor_id',$this->customer_vendor_id);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinOutstandingInvoices the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function getname($model) {
		return $model->customer_details->customer_name;
	}
}
