<?php

/**
 * This is the model class for table "{{mas_bank}}".
 *
 * The followings are the available columns in table '{{mas_bank}}':
 * @property integer $id
 * @property string $bank_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class FinAccounts extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $adtndedtn;

    public function tableName() {
        return '{{fin_accounts}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('account_no,description', 'required'),
            ///   array('bank_name', 'length', 'max' => 255),
            array('account_no', 'unique', 'on' => 'add'),
            array('account_no,description,adtndedtn', 'required', 'on' => 'adtndedtn'),
            array('account_no', 'unique', 'on' => 'adtndedtn'),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, account_no,description,credit_type isActive', 'safe', 'on' => 'search'),
            array('id, account_no,description,credit_type isActive,logistics_type,type,parent_account,product,cost_centre,isparent', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
                //   'masCompanies' => array(self::HAS_MANY, 'MasCompany', 'bank'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            // 'bank_name' => 'Bank Name',
            'isActive' => 'Is Active',
            'adtndedtn' => 'Addition/Deduction'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $account_no = Yii::app()->request->getParam('account_no');
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('account_no'));
        if (!$account_no) {

           // $criteria->addCondition('isActive =  "Y" and isvisible="Y" AND parent_account not in (50,51,52,53) and company_id=' . Yii::app()->user->master_user_company_id, 'AND');
            $criteria->addCondition('isActive =  "Y" and isvisible="Y" AND parent_account not in (50,51,52,53)', 'AND');
        } else {
            $criteria->addCondition('isActive =  "Y" and  parent_account=' . $account_no . ' and isvisible="Y" ', 'AND');
        }


        return new CActiveDataProvider($this, array(
            /*  'pagination' => array(
              'pageSize' => 5,
              ), */
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.account_no ASC',
            ),
        ));
    }

    public function searchadtndedtn() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('account_no'));
        $criteria->addCondition(' isActive =  "Y" AND (logistics_type="A" OR logistics_type="D"  OR logistics_type="PA" OR logistics_type="PD")' , 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('account_no like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.account_no ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

     public static function getAllParentAccounts() {
      //  $condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id . ' AND parent_account in (50,51,52,53)';
         $condition = 'isActive =  "Y" AND parent_account in (50,51,52,53)';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }

    public static function getAllAccounts() {
        $condition = 'isActive =  "Y" AND isParent="Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }
    public static function getAllAccounts2() {
        $condition = 'isActive =  "Y" ';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }

    public static function getAllAccountsdropdown() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }

    public static function getAdditions() {
        $condition = 'isActive =  "Y" AND logistics_type="A"';
       // $condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id . ' AND logistics_type="A"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }

    public static function getDeductions() {
        $condition = 'isActive =  "Y" AND logistics_type="D"';
      //  $condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id . ' AND logistics_type="D"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }
 public static function getAdditionsp() {
        $condition = 'isActive =  "Y" AND logistics_type="PA"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }

    public static function getDeductionsp() {
        $condition = 'isActive =  "Y" AND  logistics_type="PD"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }
    public static function getAllChildAccounts($id) {
        $condition = 'isActive =  "Y" AND  parent_account=' . $id;
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }

    public function creditbalance($data, $row) {
        $modelFinAccounts = FinAccounts::model()->findByPK($data->id);

        $modelFinGeneralLedger = FinGeneralLedger::model()->findAll(array('condition' => 'account_id=' . $data->id));
        foreach ($modelFinGeneralLedger as $eachItem) {
            $creditTotal = $creditTotal + $eachItem->credit;
            $debitTotal = $debitTotal + $eachItem->debit;
        }
        if ($modelFinAccounts->credit_type == 1)
            $creditBalanceTotal = $creditTotal - $debitTotal;
        else
            $creditBalanceTotal = $debitTotal - $creditTotal;

        if (strpos($creditBalanceTotal, '.') === false) {
            $creditBalanceTotal = $creditBalanceTotal . ".00";
        }
        return $creditBalanceTotal;
    }

    public function getparent($data) {
        $modelFinAccounts = FinAccounts::model()->findByPK($data->parent_account);

        return $modelFinAccounts->description;
    }

    public function getIdF() {
        return "a" . $this->id;
    }

    public function getDecritionWithId() {
        return $this->account_no . ':' . $this->description;
    }

    public static function getAllAcc() {
        $condition = 'isActive =  "Y"  and id not in (50,51,52,53,70,71) and parent_account not in (50,51,52,53,70,71)';
        $condition1 = 'company.isActive =  "Y" and companyType.type in ("C")';
        $condition2 = 'company.isActive =  "Y" and companyType.type in ("V")';

        $model = self::model()->findAll(array('condition' => $condition));
        $model1 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition1));
        $model2 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition2));

        $list1 = array('Accounts' => CHtml::listData($model, 'idF', 'description'));
        $list2 = array('Customers' => CHtml::listData($model1, 'company.idF', 'company.company_name'));
        $list3 = array('Vendors' => CHtml::listData($model2, 'company.idFV', 'company.company_name'));
        $list = $list1 + $list2 + $list3;
        return $list;
    }

    public static function getContraAccount() {
        $condition = ' id!=70 AND id!=71 AND (parent_account=70 OR parent_account=71) AND isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        $list = array('Accounts' => CHtml::listData($model, 'idF', 'description'));
        return $list;
    }

    public static function getReceiptAccount($selectedType) {
        if ($selectedType == 2) {
            $condition = ' id not in(70,71) AND parent_account in (70,71) AND isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'description'));
            $list = array('Accounts' => CHtml::listData($model, 'idF', 'description'));
            return $list;
        } else if ($selectedType == 1) {
           // $condition = 'parent_account in (64,62) AND isActive =  "Y"';
            $condition =  'id not in (70,71) and parent_account not in (70,71)';
            $condition1 = 'company.isActive =  "Y" and companyType.type in ("C")';
            $condition2 = 'company.isActive =  "Y" and companyType.type in ("V")';
            
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'description'));
            $model1 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition1,'order'=>'company_name'));
            $model2 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition2,'order'=>'company_name'));
            
            $list1 = array('Accounts' => CHtml::listData($model, 'idF', 'description'));
            $list2 = array('Customers' => CHtml::listData($model1, 'company.idF', 'company.company_name'));
            $list3 = array('Vendors' => CHtml::listData($model2, 'company.idFV', 'company.company_name'));
            $list = $list1 + $list2 + $list3;
            return $list;
            
        }
    }
public static function getPaymentAccount($selectedType) {
        if ($selectedType == 1) {
            $condition = ' id not in(70,71) AND parent_account in (70,71) AND isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'description'));
            $list = array('Accounts' => CHtml::listData($model, 'idF', 'description'));
            return $list;
        } else if ($selectedType == 2) {
            //$condition = 'parent_account in (66,60,58) AND isActive =  "Y"';
            $condition =  'id not in (70,71) and parent_account not in (70,71)';
            $condition1 = 'company.isActive =  "Y" and companyType.type in ("C")';
            $condition2 = 'company.isActive =  "Y" and companyType.type in ("V")';
            
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'description'));
            $model1 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition1,'order'=>'company_name'));
            $model2 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition2,'order'=>'company_name'));
            
            $list1 = array('Accounts' => CHtml::listData($model, 'idF', 'description'));
            $list2 = array('Customers' => CHtml::listData($model1, 'company.idF', 'company.company_name'));
            $list3 = array('Vendors' => CHtml::listData($model2, 'company.idFV', 'company.company_name'));
            $list = $list1 + $list2 + $list3;
            return $list;
        }
    }

    public function getCashaccounts(){
        $condition = 'isActive =  "Y" AND  parent_account IN ("4", "3")';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'description');
    }
}

