<?php

class FileTaskItems extends CActiveRecord
{

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function tableName()
	{
		return '{{file_task_items}}';
	}

	public function rules()
	{

		return array(
			array('file_head_id,file_tasks_id,task_date,task_days,task_name', 'required'),
			array('file_head_id,file_tasks_id,task_days,assigned_person', 'numerical', 'integerOnly'=>true),
                        array('notes,actual_date', 'length', 'max' => 255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, file_head_id, file_tasks_id, task_date, task_days', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'file_head_id' => 'File Head',
			'file_tasks_id' => 'File Tasks',
			'task_date' => 'Task Date',
			'task_days' => 'Task Days',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('file_head_id',$this->file_head_id);
		$criteria->compare('file_tasks_id',$this->file_tasks_id);
		$criteria->compare('task_date',$this->task_date,true);
		$criteria->compare('task_days',$this->task_days);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}