<?php

/**
 * This is the model class for table "{{exit_received_invoices}}".
 *
 * The followings are the available columns in table '{{exit_received_invoices}}':
 * @property string $id
 * @property string $exit_receipt_id
 * @property string $exit_invoice_id
 * @property string $received_amt
 * @property double $charges
 * @property integer $offers
 */
class ExitReceivedInvoices extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{exit_received_invoices}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('received_amt', 'required'),
            array('received_amt', 'numerical'),
			array('offers', 'numerical', 'integerOnly'=>true),
			array('charges', 'numerical'),
			array('exit_receipt_id, exit_invoice_id', 'length', 'max'=>20),
			array('received_amt', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, exit_receipt_id, exit_invoice_id, received_amt, charges, offers', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		 return array(
            'receipt' => array(self::BELONGS_TO, 'ExitReceiptOfPayment', 'exit_receipt_id'),
            'exitinvoice' => array(self::BELONGS_TO, 'ExitInvoice', 'exit_invoice_id'),
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'exit_receipt_id' => 'Exit Receipt',
			'exit_invoice_id' => 'Exit Invoice',
			'received_amt' => 'Received Amt',
			'charges' => 'Charges',
			'offers' => '1- Discount, 2- Not Paid',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('exit_receipt_id',$this->exit_receipt_id,true);
		$criteria->compare('exit_invoice_id',$this->exit_invoice_id,true);
		$criteria->compare('received_amt',$this->received_amt,true);
		$criteria->compare('charges',$this->charges);
		$criteria->compare('offers',$this->offers);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ExitReceivedInvoices the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
