<?php

/**
 * This is the model class for table "{{exit_receipt_of_payment}}".
 *
 * The followings are the available columns in table '{{exit_receipt_of_payment}}':
 * @property string $id
 * @property string $customer_id
 * @property string $notes
 * @property string $remarks
 * @property string $received_date
 * @property string $realisation_date
 * @property string $mode_of_payment
 * @property string $ref_number
 * @property integer $account_id1
 * @property integer $account_id
 * @property string $receipt_from
 * @property string $receipt_realisation_date
 * @property string $realisation_status
 * @property string $amount
 * @property integer $gl_id
 * @property string $chq_description
 * @property integer $form_ref_no
 * @property string $voucher_no
 * @property string $isActive
 */
class ExitReceiptOfPayment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{exit_receipt_of_payment}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, mode_of_payment, received_date,realisation_date', 'required', 'on' => 'sales'),
				array('customer_id, mode_of_payment, received_date,realisation_date', 'required', 'on' => 'purchase'),
				array('customer_id', 'length', 'max' => 20, 'on' => 'sales'),
				array('mode_of_payment', 'length', 'max' => 255, 'on' => 'sales'),
				array('ref_number', 'length', 'max' => 255, 'on' => 'sales'),
				array('isActive', 'length', 'max' => 1, 'on' => 'sales'),
				array('notes, remarks', 'length', 'max' => 5000, 'on' => 'sales'),
				array('customer_id', 'length', 'max' => 20, 'on' => 'purchase'),
				array('mode_of_payment', 'length', 'max' => 255, 'on' => 'purchase'),
				array('ref_number', 'length', 'max' => 255, 'on' => 'purchase'),
				array('isActive', 'length', 'max' => 1, 'on' => 'purchase'),
				array('notes, remarks', 'length', 'max' => 5000, 'on' => 'purchase'),
				// The following rule is used by search().
				// @todo Please remove those attributes that should not be searched.
				array('id, customer_id, notes, remarks, received_date,realisation_date,mode_of_payment, ref_number, isActive', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'recieved_invoice' => array(self::HAS_MANY, 'ExitReceivedInvoices', 'exit_receipt_id'),
				'recieved_amount' => array(self::STAT, 'ExitReceivedInvoices', 'exit_receipt_id', 'select' => 'SUM(received_amt)'),
				'paid_amount' => array(self::STAT, 'PaidInvoices', 'exit_receipt_id', 'select' => 'SUM(received_amt)'),
				'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'notes' => 'Notes',
			'remarks' => 'Remarks',
			'received_date' => 'Received Date',
			'realisation_date' => 'Realisation Date',
			'mode_of_payment' => 'Mode Of Payment',
			'ref_number' => 'Ref Number',
			'account_id1' => 'Account Id1',
			'account_id' => 'Account',
			'receipt_from' => 'Receipt From',
			'receipt_realisation_date' => 'Receipt Realisation Date',
			'realisation_status' => 'Realisation Status',
			'amount' => 'Amount',
			'gl_id' => 'Gl',
			'chq_description' => 'Chq Description',
			'form_ref_no' => 'Form Ref No',
			'voucher_no' => 'Voucher No',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('customer_id',$this->customer_id,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('received_date',$this->received_date,true);
		$criteria->compare('realisation_date',$this->realisation_date,true);
		$criteria->compare('mode_of_payment',$this->mode_of_payment,true);
		$criteria->compare('ref_number',$this->ref_number,true);
		$criteria->compare('account_id1',$this->account_id1);
		$criteria->compare('account_id',$this->account_id);
		$criteria->compare('receipt_from',$this->receipt_from,true);
		$criteria->compare('receipt_realisation_date',$this->receipt_realisation_date,true);
		$criteria->compare('realisation_status',$this->realisation_status,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('gl_id',$this->gl_id);
		$criteria->compare('chq_description',$this->chq_description,true);
		$criteria->compare('form_ref_no',$this->form_ref_no);
		$criteria->compare('voucher_no',$this->voucher_no,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ExitReceiptOfPayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
