<?php

/**
 * This is the model class for table "{{exit_invoice_item}}".
 *
 * The followings are the available columns in table '{{exit_invoice_item}}':
 * @property string $id
 * @property integer $product_id
 * @property integer $invoice_id
 * @property string $description
 * @property string $quantity
 * @property string $rate
 * @property string $amount
 * @property string $net_amount
 * @property string $cost_rate
 */
class ExitInvoiceItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $product_name;
	public $unit;
	public $item_code;
	public $vat;
	public function tableName()
	{
		return '{{exit_invoice_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, description, quantity, rate, amount', 'required'),
			array('product_id, exit_invoice_id', 'numerical', 'integerOnly'=>true),
			array('quantity, rate, amount, cost_rate', 'length', 'max'=>15),
			array(
					'rate',
					'compare',
					'compareValue' => 0,
					'operator' => '>',
					'allowEmpty' => false,
					'message' => '{attribute} must be greater than "{compareValue}".'
			),
			array(
					'amount',
					'compare',
					'compareValue' => 0,
					'operator' => '>=',
					'allowEmpty' => false,
					'message' => '{attribute} must be greater than or equal to "{compareValue}".'
			),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, exit_invoice_id, description, quantity, rate, amount, net_amount, cost_rate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'invoice' => array(self::BELONGS_TO, 'Invoice', 'exit_invoice_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'exit_invoice_id' => 'Invoice',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'rate' => 'Rate',
			'amount' => 'Amount',
			'net_amount' => 'Net Amount',
			'cost_rate' => 'Cost Rate',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('exit_invoice_id',$this->exit_invoice_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('net_amount',$this->net_amount,true);
		$criteria->compare('cost_rate',$this->cost_rate,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ExitInvoiceItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
