<?php

/**
 * This is the model class for table "{{entry_invoice_manifest_no}}".
 *
 * The followings are the available columns in table '{{entry_invoice_manifest_no}}':
 * @property integer $id
 * @property integer $entry_invoice_id
 * @property string $manifest_no
 * @property string $origin
 * @property string $goods
 * @property string $weight
 * @property integer $quantity
 * @property string $value
 */
class EntryInvoiceManifestNo extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{entry_invoice_manifest_no}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('entry_invoice_id, manifest_no', 'required'),
			array('entry_invoice_id, quantity', 'numerical', 'integerOnly'=>true),
			array('manifest_no, origin, goods, weight', 'length', 'max'=>255),
			array('value', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, entry_invoice_id, manifest_no, origin, goods, weight, quantity, value', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'entry_invoice_id' => 'Entry Invoice',
			'manifest_no' => 'Manifest No',
			'origin' => 'Origin',
			'goods' => 'Goods',
			'weight' => 'Weight',
			'quantity' => 'Quantity',
			'value' => 'Value',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('entry_invoice_id',$this->entry_invoice_id);
		$criteria->compare('manifest_no',$this->manifest_no,true);
		$criteria->compare('origin',$this->origin,true);
		$criteria->compare('goods',$this->goods,true);
		$criteria->compare('weight',$this->weight,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('value',$this->value,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EntryInvoiceManifestNo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}


}