<?php

/**
 * This is the model class for table "{{documents}}".
 *
 * The followings are the available columns in table '{{documents}}':
 * @property integer $id
 * @property integer $process_id
 * @property string $company_id
 * @property string $document_name
 * @property string $uploaded_from
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasterFile $process
 * @property Company $company
 */
class Document extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{document}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('file_id, document_name, uploaded_from', 'required'),
            array('file_id', 'numerical', 'integerOnly' => true),
            array('document_name,document', 'length', 'max' => 5000),
            array('isActive,uploaded_from', 'length', 'max' => 3),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, file_id, document_name, uploaded_from, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'cus_details' => array(self::BELONGS_TO, 'Customer', 'customer_id')
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'file_id' => 'File',
            'document_name' => 'Documents',
            'uploaded_from' => 'Uploaded From',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $file_id = isset(Yii::app()->session['file_id']) && (int) Yii::app()->session['file_id'] > 0 ? Yii::app()->session['file_id'] : -999;
        $criteria->compare('id', $this->id);
        $criteria->compare('file_id', $file_id);
        $criteria->compare('document_name', $this->document_name, true);
        $criteria->compare('uploaded_from', $this->uploaded_from, true);
        $criteria->compare('isActive', $this->isActive, true);
        if (isset($_POST['file']))
            $criteria->condition = 'file_id=' . (int) $_POST['file'];

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.file_id DESC',
            ),
            'pagination' => array('pageSize' => /* Yii::app()->params['defaultPageSize'] */5)
        ));
    }

    public function getStatus() {
        switch ($this->uploaded_from) {
            case 'L':
                return 'Lead';
                break;
            case 'Q':
                return 'Quote';
                break;
            case 'O':
            case 'P_O':
                return 'Order';
                break;
            case 'D':
                return 'Delivery';
                break;
            case 'PD':
                return 'P.Delivery';
                break;
            case 'I':
            case 'P_I':
                return 'Invoice';
                break;
            case 'PI':
            case 'P_PI':
                return 'P.Invoice';
                break;
            case 'P_R':
                return 'Requisition';
                break;
            case 'P_E':
                return 'Enquiry';
                break;
            case 'M_R':
                return 'Receipt';
                break;
            case 'P_MR':
                return 'P.Receipt';
                break;
            case 'P_C':
            case 'C':
                return 'Credit Note/G.Return';
                break;
            case 'B_M':
                return 'Bill of Mtl';
                break;
            case 'PR_O':
                return 'Prod.Order';
                break;
            case 'G_I':
                return 'Goods Issue';
                break;
            case 'G_R':
                return 'Goods Receipt';
                 break;
            case 'T':
                return 'Tender';
                break;
             case 'BOQ':
                return 'BOQ';
                break;
        }
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Documents the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}