<?php

/**
 * This is the model class for table "{{direct_order_item}}".
 *
 * The followings are the available columns in table '{{direct_order_item}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $product_id
 * @property string $description
 * @property string $part_no
 * @property string $quantity
 * @property integer $unit_id
 * @property string $rate
 * @property string $amount
 */
class DirectOrderItem extends CActiveRecord
{
	public $unit;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{direct_order_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_id, product_id, description, part_no, quantity, unit_id, rate, amount', 'required'),
			array('order_id, product_id, unit_id', 'numerical', 'integerOnly'=>true),
			array('part_no', 'length', 'max'=>255),
			array('quantity, rate, amount, tax_amount, tax_percentage ,deduction_percentage, deduction_amount ', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, order_id, product_id, description, part_no, quantity, unit_id, rate, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'parent' => array(self::BELONGS_TO, 'DirectOrder', 'order_id'),
                    'product_id' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'orderunit' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'order_id' => 'Order',
			'product_id' => 'Product',
			'description' => 'Description',
			'part_no' => 'Part No',
			'quantity' => 'Quantity',
			'unit_id' => 'Unit',
			'rate' => 'Rate',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('order_id',$this->order_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('part_no',$this->part_no,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('amount',$this->amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DirectOrderItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
