<?php

/**
 * This is the model class for table "{{direct_order}}".
 *
 * The followings are the available columns in table '{{direct_order}}':
 * @property string $id
 * @property integer $invoice_id
 * @property string $customer_id
 * @property integer $contact_id
 * @property string $billing_address
 * @property string $shipping_address
 * @property string $order_date
 * @property integer $currency_id
 * @property string $exchange_rate
 * @property string $grand_total
 * @property string $is_posted
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 */
class DirectOrder extends CActiveRecord
{
	public $customer_name;
        public $contact_name;
        /**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{direct_order}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, order_date,invoice_type', 'required'),
			array('invoice_no, contact_id, currency_id, created_by, updated_by,file_id', 'numerical', 'integerOnly'=>true),
			array('customer_id,', 'length', 'max'=>20),
			array('exchange_rate, grand_total,total_tax_amount', 'length', 'max'=>15),
			array('notes,remarks,terms_and_conditions', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, invoice_id, customer_id, contact_id, billing_address,notes,remarks,terms_and_conditions, shipping_address, order_date, currency_id, exchange_rate, grand_total,invoice_type,  created_by, updated_by, created_date_time, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'file_details' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
                    'currency_details' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
                    'customer_details' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
                    'contact_details' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
                    'netAmount' => array(self::STAT, 'DirectOrderItem', 'order_id', 'select' => 'SUM(amount)'),
                    'netVat' => array(self::STAT, 'DirectOrderItem', 'order_id', 'select' => 'SUM(tax_amount)'),
                    'adItems' => array(self::HAS_MANY, 'DirectOrderAddition', 'order_id'),
                    'dedItems' => array(self::HAS_MANY, 'DirectOrderDeduction', 'order_id'),
					'invoicetype' => array(self::BELONGS_TO, 'MasInvoiceType', 'invoice_type'),
					'user' => array(self::BELONGS_TO, 'User', 'created_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'invoice_id' => 'invoice',
			'file_id' => 'File Id',
			'customer_id' => 'Customer',
			'contact_id' => 'Contact',
			'billing_address' => 'Billing Address',
			'shipping_address' => 'Shipping Address',
			'order_date' => 'Order Date',
			'currency_id' => 'Currency',
			'exchange_rate' => 'Exchange Rate',
			'grand_total' => 'Grand Total',
            'invoice_type' => 'Invoice Type',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_date_time' => 'Created Datetime',
			'updated_date_time' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('invoice_id',$this->invoice_id);
		$criteria->compare('customer_id',$this->customer_id,true);
		$criteria->compare('contact_id',$this->contact_id);
		$criteria->compare('billing_address',$this->billing_address,true);
		$criteria->compare('shipping_address',$this->shipping_address,true);
		$criteria->compare('order_date',$this->order_date,true);
		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('exchange_rate',$this->exchange_rate,true);
		$criteria->compare('grand_total',$this->grand_total,true);
        $criteria->compare('invoice_type',$this->invoice_type,true);
		$criteria->compare('is_posted',$this->is_posted,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DirectOrder the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
