<?php

/**
 * This is the model class for table "{{deposit}}".
 *
 * The followings are the available columns in table '{{deposit}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $bill_of_entry
 * @property string $invoice_no
 * @property string $amount
 * @property string $issued_date
 * @property string $expiry_date
 * @property string $notes
 * @property string $doc_submitted_date
 * @property string $customs_submitted_date
 * @property string $payment_collection_date
 * @property string $payment_delivery_date
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_datetime
 */
class Deposit extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $customer_name;
	public function tableName()
	{
		return '{{deposit}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, bill_of_entry, invoice_no, amount, issued_date, expiry_date', 'required'),
			array('customer_id, created_by', 'numerical', 'integerOnly'=>true),
			array('bill_of_entry, invoice_no', 'length', 'max'=>255),
			array('amount', 'length', 'max'=>15),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, bill_of_entry, invoice_no, amount, issued_date, expiry_date, notes, doc_submitted_date, customs_submitted_date, payment_collection_date, payment_delivery_date, isActive, created_by, created_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'cus' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'bill_of_entry' => 'Bill Of Entry',
			'invoice_no' => 'Invoice No',
			'amount' => 'Amount',
			'issued_date' => 'Issued Date',
			'expiry_date' => 'Expiry Date',
			'notes' => 'Notes',
			'doc_submitted_date' => 'Doc Submitted Date',
			'customs_submitted_date' => 'Customs Submitted Date',
			'payment_collection_date' => 'Payment Collection Date',
			'payment_delivery_date' => 'Payment Delivery Date',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'statement_no' => 'Statement No',
			'receipt_no' => 'Receipt No',
			'collected_cheque_no' => 'Cheque/Bank',
			'delivered_cheque_no' => 'Cheque/Bank',
			'created_datetime' => 'Created Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('bill_of_entry',$this->bill_of_entry,true);
		$criteria->compare('invoice_no',$this->invoice_no,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('issued_date',$this->issued_date,true);
		$criteria->compare('expiry_date',$this->expiry_date,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('doc_submitted_date',$this->doc_submitted_date,true);
		$criteria->compare('customs_submitted_date',$this->customs_submitted_date,true);
		$criteria->compare('payment_collection_date',$this->payment_collection_date,true);
		$criteria->compare('payment_delivery_date',$this->payment_delivery_date,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Deposit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
