<?php

/**
 * This is the model class for table "{{demo_item_general}}".
 *
 * The followings are the available columns in table '{{demo_item_general}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property string $item_issue_date
 * @property string $item_return_date
 * @property string $notes
 * @property string $terms_conditions
 * @property string $is_active
 * @property string $reference
 * @property integer $customer_id
 * @property integer $connected_file
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class DemoItemGeneral extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    
        public $customer_name;
        public function tableName()
	{
		return '{{demo_item_general}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('crm_user_id, item_issue_date, customer_id', 'required'),
			array('crm_user_id, customer_id, connected_file, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('is_active', 'length', 'max'=>1),
			array('reference,terms_conditions', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, crm_user_id, item_issue_date, item_return_date, notes, terms_conditions, is_active, reference, customer_id, connected_file, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'company' => array(self::BELONGS_TO, 'Company', 'customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'crm_user_id' => 'Crm User',
			'item_issue_date' => 'Item Issue Date',
			'item_return_date' => 'Item Return Date',
			'notes' => 'Notes',
			'terms_conditions' => 'Terms Conditions',
			'is_active' => 'Is Active',
			'reference' => 'Reference',
			'customer_id' => 'Customer',
			'connected_file' => 'Connected File',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
        $searchterm = Yii::app()->request->getParam('demo_search');
        $criteria=new CDbCriteria;
        $criteria->with = array('company');
        if (!empty($searchterm)) {
            $criteria->addCondition('t.id like "%' . $searchterm . '%" OR company.company_name like "%' . $searchterm . '%" OR t.reference like "%' . $searchterm . '%"', 'AND');
        }

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
                        'sort' => array(
                        'defaultOrder' => 't.id DESC',
            ),
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DemoItemGeneral the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
