<?php

/**
 * This is the model class for table "{{customers}}".
 *
 * The followings are the available columns in table '{{customers}}':
 * @property string $id

 * @property string $customer_name
 * @property string $customer_credit_limit
 * @property integer $customer_currency_id
 * @property string $customer_address
 * @property string $customer_city
 * @property string $customer_postal_code
 * @property string $customer_state
 * @property string $customer_country
 * @property string $customer_bank_tax_id
 * @property string $customer_bank_account_no
 * @property string $customer_bank_swift
 * @property string $customer_bank_account_name
 * @property integer $customer_bank_id
 * @property string $customer_bank_name
 * @property string $customer_bank_branch_name
 * @property string $customer_bank_iban
 * @property string $customer_bank_ifsc
 * @property string $customer_bank_others
 * @property string $customer_phone_no
 * @property string $customer_email_id
 * @property string $customer_location
 * @property string $customer_payment_term
 * @property string $customer_fax
 * @property string $customer_web
 * @property string $customer_industry
 * @property string $is_approved
 * @property string $isActive
 * @property string $created_date
 * @property integer $created_by
 * @property string $last_updated_date
 * @property integer $last_updated_by
 */
class Customers extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $file_title;
        public $contract_no;
        public $type_of_contract;
        public $contract_date_to;
        public $contract_date_from;
	public function tableName()
	{
		return '{{customers}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_name,customer_email_id,customer_phone_no', 'required'),
			array(' customer_currency_id, customer_bank_id,customer_country, created_by, last_updated_by', 'numerical', 'integerOnly'=>true),
			array('customer_name, customer_city,customer_address ,customer_postal_code, customer_state,  customer_bank_tax_id, customer_bank_account_no, customer_bank_swift, customer_bank_account_name, customer_bank_name, customer_bank_branch_name, customer_bank_iban, customer_bank_ifsc, customer_bank_others, customer_phone_no, customer_email_id, customer_location, customer_payment_term, customer_fax, customer_web, customer_industry', 'length', 'max'=>255),
			array('customer_credit_limit', 'length', 'max'=>15),
			array('is_approved, isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_name, customer_credit_limit, customer_currency_id, customer_address, customer_city, customer_postal_code, customer_state, customer_country, customer_bank_tax_id, customer_bank_account_no, customer_bank_swift, customer_bank_account_name, customer_bank_id, customer_bank_name, customer_bank_branch_name, customer_bank_iban, customer_bank_ifsc, customer_bank_others, customer_phone_no, customer_email_id, customer_location, customer_payment_term, customer_fax, customer_web, customer_industry, is_approved, isActive, created_date, created_by, last_updated_date, last_updated_by, notes,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'country' => array(self::BELONGS_TO, 'MasCountry','customer_country'),
                    'currency_detail' => array(self::BELONGS_TO, 'MasCurrency','customer_currency_id'),
                    'contractdetails' => array(self::HAS_MANY, 'Contract','customer_id'),
                    'registrationdetails' => array(self::HAS_MANY, 'Registration','customer_id'),
                    'customercontact' => array(self::HAS_ONE, 'CustomerContact','customer_id'),

		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			
			'customer_name' => 'Customer Name',
			'customer_credit_limit' => 'Customer Credit Limit',
			'customer_currency_id' => 'Customer Currency',
			'customer_address' => 'Customer Address',
			'customer_city' => 'Customer City',
			'customer_postal_code' => 'Customer Postal Code',
			'customer_state' => 'Customer State',
			'customer_country' => 'Customer Country',
			'customer_bank_tax_id' => 'Customer Bank Tax',
			'customer_bank_account_no' => 'Customer Bank Account No',
			'customer_bank_swift' => 'Customer Bank Swift',
			'customer_bank_account_name' => 'Customer Bank Account Name',
			'customer_bank_id' => 'Customer Bank',
			'customer_bank_name' => 'Customer Bank Name',
			'customer_bank_branch_name' => 'Customer Bank Branch Name',
			'customer_bank_iban' => 'Customer Bank Iban',
			'customer_bank_ifsc' => 'Customer Bank Ifsc',
			'customer_bank_others' => 'Customer Bank Others',
			'customer_phone_no' => 'Customer Phone No',
			'customer_email_id' => 'Customer Email',
			'customer_location' => 'Customer Location',
			'customer_payment_term' => 'Customer Payment Term',
			'customer_fax' => 'Customer Fax',
			'customer_web' => 'Customer Web',
			'customer_industry' => 'Customer Industry',
			'is_approved' => 'Is Approved',
			'isActive' => 'Is Active',
			'created_date' => 'Created Date',
			'created_by' => 'Created By',
			'last_updated_date' => 'Last Updated Date',
			'last_updated_by' => 'Last Updated By',
                        'notes' =>'notes'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		
		$criteria->compare('customer_name',$this->customer_name,true);
		$criteria->compare('customer_credit_limit',$this->customer_credit_limit,true);
		$criteria->compare('customer_currency_id',$this->customer_currency_id);
		$criteria->compare('customer_address',$this->customer_address,true);
		$criteria->compare('customer_city',$this->customer_city,true);
		$criteria->compare('customer_postal_code',$this->customer_postal_code,true);
		$criteria->compare('customer_state',$this->customer_state,true);
		$criteria->compare('customer_country',$this->customer_country,true);
		$criteria->compare('customer_bank_tax_id',$this->customer_bank_tax_id,true);
		$criteria->compare('customer_bank_account_no',$this->customer_bank_account_no,true);
		$criteria->compare('customer_bank_swift',$this->customer_bank_swift,true);
		$criteria->compare('customer_bank_account_name',$this->customer_bank_account_name,true);
		$criteria->compare('customer_bank_id',$this->customer_bank_id);
		$criteria->compare('customer_bank_name',$this->customer_bank_name,true);
		$criteria->compare('customer_bank_branch_name',$this->customer_bank_branch_name,true);
		$criteria->compare('customer_bank_iban',$this->customer_bank_iban,true);
		$criteria->compare('customer_bank_ifsc',$this->customer_bank_ifsc,true);
		$criteria->compare('customer_bank_others',$this->customer_bank_others,true);
		$criteria->compare('customer_phone_no',$this->customer_phone_no,true);
		$criteria->compare('customer_email_id',$this->customer_email_id,true);
		$criteria->compare('customer_location',$this->customer_location,true);
		$criteria->compare('customer_payment_term',$this->customer_payment_term,true);
		$criteria->compare('customer_fax',$this->customer_fax,true);
		$criteria->compare('customer_web',$this->customer_web,true);
		$criteria->compare('customer_industry',$this->customer_industry,true);
		$criteria->compare('is_approved',$this->is_approved,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('last_updated_date',$this->last_updated_date,true);
		$criteria->compare('last_updated_by',$this->last_updated_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Customers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getCustomers()
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'customer_name'));
		return CHtml::listData($model, 'id', 'customer_name');
	}
}
