<?php

/**
 * This is the model class for table "{{company_contact}}".
 *
 * The followings are the available columns in table '{{company_contact}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property string $company_id
 * @property string $person_name
 * @property string $designation
 * @property string $ph_no
 * @property integer $department
 * @property string $mobile1
 * @property string $mobile2
 * @property string $email1
 * @property string $email2
 * @property string $dob
 * @property integer $contact_method
 * @property string $notes
 * @property string $do_not_call
 * @property string $do_not_email
 * @property string $news_letter
 * @property string $facebook
 * @property string $skype
 * @property string $linkedin
 * @property string $instagram
 * @property string $googleplus
 * @property string $twitter
 * @property string $myspace
 * @property string $youtube
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property User $crmUser
 * @property Company $company
 * @property CreditNote[] $creditNotes
 * @property DeliveryNotes[] $deliveryNotes
 * @property Event[] $events
 * @property Quotes[] $quotes
 */
class CustomerContact extends CActiveRecord {

    public $company_name;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{company_contact}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('crm_user_id, company_id, person_name,title
                ', 'required'),
            array('id, crm_user_id, contact_method', 'numerical', 'integerOnly' => true),
            array('company_id', 'length', 'max' => 20),
            array('company_name, person_name, designation, ph_no, mobile1, mobile2, email1, email2, department,
                facebook, skype, linkedin, instagram, googleplus, twitter, myspace,dob,notes, youtube', 'length', 'max' => 255),
            array('do_not_call, do_not_email, news_letter, isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id, company_id, person_name, designation, ph_no, 
                department, mobile1, mobile2, email1, email2, dob, contact_method, 
                notes, do_not_call, do_not_email, news_letter, facebook, skype, 
                linkedin, instagram, googleplus, twitter, myspace, youtube, isActive', 'safe', 'on' => 'search'),
                // array('facebook,youtube', 'url', 'defaultScheme' => 'http'),
                //  array('email1, email2', 'email')
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'company_id'),
            'creditNotes' => array(self::HAS_MANY, 'CreditNote', 'contact_id'),
            'deliveryNotes' => array(self::HAS_MANY, 'DeliveryNotes', 'contact_id'),
            'events' => array(self::HAS_MANY, 'Event', 'contact_id'),
            'quotes' => array(self::HAS_MANY, 'Quotes', 'contact_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'company_id' => 'Company',
            'person_name' => 'Contact Person',
            'designation' => 'Designation',
            'ph_no' => 'Phone No.',
            'department' => 'Department',
            'mobile1' => 'Mobile #1',
            'mobile2' => ' Mobile #2',
            'email1' => ' E-mail #1',
            'email2' => 'E-mail #2',
            'dob' => 'DoB',
            'contact_method' => 'Contact Method',
            'notes' => 'Notes',
            'do_not_call' => 'Do Not Call',
            'do_not_email' => 'Do Not Email',
            'news_letter' => 'News Letter',
            'facebook' => 'Facebook',
            'skype' => 'Skype',
            'linkedin' => 'Linkedin',
            'instagram' => 'Instagram',
            'googleplus' => 'Googleplus',
            'twitter' => 'Twitter',
            'myspace' => 'Myspace',
            'youtube' => 'Youtube',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {

		$company_id= trim(Yii::app()->request->getParam('company_id'));

        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('contact_search')) : $searchterm;
        $criteria->with = array('customer', 'crmUser', 'customer.CustomerTypeRelation');
        $criteria->together = true;
       
//        (int) Yii::app()->session['company_id'] > 0 ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.person_name like "%' . $searchterm . '%" OR 
                                        t.designation like "%' . $searchterm . '%" OR 
                                        t.department like "%' . $searchterm . '%" OR 
                                        customer.customer_name like "%' . $searchterm . '%"', 'AND');
        }
//        if (!(int) Yii::app()->user->havePermissionOn['masters_company_view_customer'])
//            $criteria->addCondition('CustomerTypeRelation.type_id<>1', 'AND');
//        if (!(int) Yii::app()->user->havePermissionOn['masters_company_view_vendor'])
//            $criteria->addCondition('CustomerTypeRelation.type_id<>2', 'AND');                        

		if(!empty($company_id)){
                    $criteria->addCondition('t.company_id='.$company_id,'AND');
                }

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.person_name,t.company_id',
            ),
 
            'pagination' => array('pageSize' => 5,            'pageVar'=>'custom-page-selector'            )
        ));
    }

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = 'customer';
        if (!empty($this->company_id))
            $criteria->addCondition('company_id=' . $this->company_id, 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'customer.customer_name',
            ),
            'pagination' => false
        ));
    }

    /* returning email ids */

    public function getEmailids() {
        return $this->email1 . ',' . $this->email2;
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return CompanyContact the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getFullname() {
        if ($this->person_name != "Sales / Account")
            return $this->title . ". " . $this->person_name;
        else
            return $this->person_name;
    }

    public static function getContacts($company_id = 0) {
        if ((int) $company_id) {
            
            $condition = 'isActive="Y" AND company_id =  ' . $company_id;
            $model = self::model()->findAll(array('condition' => $condition, 'order' => 'person_name ASC'));
            return CHtml::listData($model, 'id', 'person_name');
        }
        else{
            $model = self::model()->findAll();
            return CHtml::listData($model, 'id', 'person_name');
        }
        return array();
    }
    public static function getContactName($contact_id = 0) {
    		$model = self::model()->findByPk($contact_id);
    		return $model->title . ". " . $model->person_name;
    }

}
